/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Locale;
import oracle.net.common.NetStrings;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.ServiceAliasHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.ServiceAlias;
import oracle.net.config.Alias;
import oracle.net.config.ConfigException;

public class LDAPServiceAliasHandler
extends ServiceAliasHandler {
    private LDAPDataStore m_lds;
    private static NetStrings ns = new NetStrings("oracle.net.common.mesg.NetCommonSR", Locale.getDefault());

    LDAPServiceAliasHandler(LDAPDataStore lDAPDataStore) {
        super(false);
        this.m_lds = lDAPDataStore;
    }

    @Override
    public void save() throws DataStoreException {
        int n;
        int n2;
        if (!this.removeLog.isEmpty()) {
            try {
                n2 = this.removeLog.size();
                for (n = 0; n < n2; ++n) {
                    Alias.delete(this.m_lds.config, this.removeLog.elementAt(n).toString());
                }
            }
            catch (Exception exception) {
                throw new DataStoreException(ns.getString("RemoveAlias-04501", new Object[]{this.m_lds}), exception);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                n2 = this.changeLog.size();
                for (n = 0; n < n2; ++n) {
                    String string = this.changeLog.elementAt(n).toString();
                    Object v = this.table.get(string);
                    if (v == null || v.equals("NOT_LOADED")) {
                        throw new DataStoreException(ns.getString("NoAlias-04502", new Object[]{string, "none"}));
                    }
                    if (!(v instanceof ServiceAlias)) {
                        throw new DataStoreException(ns.getString("WrongType-04503", new Object[]{string, v}));
                    }
                    ServiceAlias serviceAlias = (ServiceAlias)v;
                    new Alias(serviceAlias.getName(), serviceAlias.getAliasedName(), serviceAlias.getOracleContextDN()).save(this.m_lds.config);
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
            }
            catch (Exception exception) {
                throw new DataStoreException(ns.getString("Save-04504", new Object[]{this.m_lds}), exception);
            }
        }
    }

    @Override
    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = Alias.enumAliases(this.m_lds.config);
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.m_lds.config.getDS().getCN(stringArray[i], true);
                this.table.put(string, "NOT_LOADED");
            }
        }
        catch (ConfigException configException) {
            throw new DataStoreException(configException.getMessage(), configException);
        }
    }

    public String[] enumConfigObjects(String string) throws DataStoreException {
        String[] stringArray;
        try {
            stringArray = Alias.enumAliases(this.m_lds.config, string);
        }
        catch (ConfigException configException) {
            throw new DataStoreException(configException.getMessage(), configException);
        }
        return stringArray;
    }

    @Override
    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        try {
            Alias alias = Alias.load(this.m_lds.config, string);
            if (alias == null) {
                throw new DataStoreException(ns.getString("NoAlias-04502", new Object[]{string, "null"}));
            }
            return new ServiceAlias(string, alias.getAliasedName(), alias.getOracleContextDN());
        }
        catch (ConfigException configException) {
            throw new DataStoreException(configException);
        }
    }
}

