/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Vector;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;

public class LDAPNetServiceHandler
extends NetServiceHandler {
    private LDAPDataStore lds;

    LDAPNetServiceHandler(LDAPDataStore lDAPDataStore) {
        super(false);
        this.lds = lDAPDataStore;
    }

    @Override
    public void save() throws DataStoreException {
        if (!this.removeLog.isEmpty()) {
            try {
                int n = this.removeLog.size();
                for (int i = 0; i < n; ++i) {
                    ServiceAlias.delete(this.lds.config, this.removeLog.elementAt(i).toString());
                }
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while removing ServiceAlias from LDAP" + this.lds, exception);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                ServiceAlias serviceAlias = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[2];
                nArray[0] = 2;
                nArray[1] = 3;
                int[] nArray2 = nArray;
                NetService netService = null;
                int n = this.changeLog.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.changeLog.elementAt(i).toString();
                    Object v = this.table.get(string);
                    if (!(v instanceof NetService)) {
                        throw new DataStoreException("Exception saving NetService to: " + this.lds + ", data error." + string + " = " + netService);
                    }
                    netService = (NetService)v;
                    if (netService == null || netService.equals("NOT_LOADED")) {
                        throw new DataStoreException("Exception saving NetService to: " + this.lds + ", data error." + string + " = " + netService);
                    }
                    serviceAlias = new ServiceAlias(this.lds.config, string);
                    vector.removeAllElements();
                    vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray2));
                    serviceAlias.setEndpoints(vector);
                    serviceAlias.save(this.lds.config, true);
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
            }
            catch (ServiceAliasException serviceAliasException) {
                throw new DataStoreException("error writing ServiceAlias to: " + this.lds, serviceAliasException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new DataStoreException("error saving to: " + this.lds + " msg: ", sOExceptionConfig);
            }
        }
    }

    @Override
    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = ServiceAlias.enumServiceAliases(this.lds.config, null, true);
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.lds.config.getDS().getCN(stringArray[i], true);
                this.table.put(string, "NOT_LOADED");
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    @Override
    public String[] enumDomains() throws DataStoreException {
        return new String[]{this.lds.getOracleContext()};
    }

    @Override
    public String[] enumConfigObjects(String string) throws DataStoreException {
        try {
            return ServiceAlias.enumServiceAliases(this.lds.config, string, false);
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    @Override
    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        try {
            ServiceAlias serviceAlias = new ServiceAlias(this.lds.config, string);
            return new NetService("(" + string + "=" + serviceAlias.toString() + ")");
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }
}

