/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DBServiceDataStorer;
import oracle.net.common.dataStore.DBServiceHandler;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDBServiceHandler;
import oracle.net.common.dataStore.LDAPNetServiceHandler;
import oracle.net.common.dataStore.LDAPServiceAliasHandler;
import oracle.net.common.dataStore.LDAPServiceHandler;
import oracle.net.common.dataStore.NetServiceDataStorer;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.dataStore.ServiceAliasDataStorer;
import oracle.net.common.dataStore.ServiceAliasHandler;
import oracle.net.common.dataStore.ServiceDataStorer;
import oracle.net.common.dataStore.ServiceHandler;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DirectoryServiceException;

public class LDAPDataStore
extends DataStore
implements NetServiceDataStorer,
DBServiceDataStorer,
ServiceDataStorer,
ServiceAliasDataStorer {
    Config config;
    private LDAPNetServiceHandler netServiceHandler;
    private LDAPDBServiceHandler dbServiceHandler;
    private LDAPServiceHandler serviceHandler;
    private LDAPServiceAliasHandler serviceAliasHandler;
    private String contextAsDomain;
    private int m_authType = -1;
    private String[] m_credentials = null;
    private boolean m_authenticated;
    public static final String ORACLE_SOFTWARE_NAME = "OracleContext";
    public static final String ORACLE_SOFTWARE_RDN = "cn=OracleContext";

    public LDAPDataStore() throws DataStoreException {
        this._initConfig();
        this._init(this.config.getDirectoryServers(true), this.config.getDirectoryType(), this.config.getDefaultOracleContext(false), this.config.getConnectionTimeout());
    }

    public LDAPDataStore(String string) throws DataStoreException {
        this._initConfig();
        this._init(this.config.getDirectoryServers(true), this.config.getDirectoryType(), string, this.config.getConnectionTimeout());
    }

    public LDAPDataStore(String[] stringArray, String string, String string2) throws DataStoreException {
        this._initConfig();
        this._init(stringArray, string, string2, this.config.getConnectionTimeout());
    }

    public LDAPDataStore(String[] stringArray, String string, String string2, String string3) throws DataStoreException {
        this._initConfig();
        this._init(stringArray, string, string2, string3);
    }

    private void _init(String[] stringArray, String string, String string2, String string3) throws DataStoreException {
        if (this.config == null) {
            this._initConfig();
        }
        if (stringArray == null || string == null || string2 == null) {
            throw new DataStoreException("unable to construct LDAPDataStore: null parameter");
        }
        if (!(string2 = string2.trim()).substring(0, ORACLE_SOFTWARE_RDN.length()).equalsIgnoreCase(ORACLE_SOFTWARE_RDN)) {
            throw new DataStoreException("unable to construct LDAPDataStore: invalid oracle context: " + string2);
        }
        this.config.setDirectoryServers(stringArray);
        this.config.setDirectoryType(string);
        String string4 = null;
        this.config.setCurrentOracleContext(string2);
        string4 = string2.equalsIgnoreCase(ORACLE_SOFTWARE_RDN) ? "" : string2.substring(ORACLE_SOFTWARE_RDN.length() + 1, string2.length());
        this.config.namingContext(string4);
        if (string3 != null) {
            this.config.setConnectionTimeout(string3);
        }
        this.contextAsDomain = string4 != null && !string4.equals("") ? this.toDNSFromDN(string4) : "";
    }

    private void _initConfig() throws DataStoreException {
        try {
            String[] stringArray = new String[]{null, null};
            this.config = new Config(NetGetEnv.getOracleHome(), 1, stringArray);
            this.m_authenticated = false;
            this.config.netConfigUsesLDAP(true);
        }
        catch (ConfigException configException) {
            throw new DataStoreException(configException);
        }
    }

    public static int compareVersions(String string, String string2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 46;
        int n6 = string.indexOf(n5, n3);
        int n7 = string2.indexOf(n5, n4);
        while (n6 != -1 && n7 != -1) {
            n2 = new Integer(string.substring(n3, n6));
            if (n2 != (n = new Integer(string2.substring(n4, n7)).intValue())) {
                return n2 - n;
            }
            n3 = n6 + 1;
            n4 = n7 + 1;
            n6 = string.indexOf(n5, n3);
            n7 = string2.indexOf(n5, n4);
        }
        if (n6 == -1) {
            n2 = new Integer(string.substring(n3));
            if (n7 == -1) {
                n = new Integer(string2.substring(n4));
                if (n2 != n) {
                    return n2 - n;
                }
                return 0;
            }
            n = new Integer(string2.substring(n4, n7));
            if (n2 != n) {
                return n2 - n;
            }
            n4 = n7 + 1;
            n7 = string2.indexOf(n5, n4);
            while (n7 != -1) {
                n = new Integer(string2.substring(n4, n7));
                if (n > 0) {
                    return -1;
                }
                n4 = n7 + 1;
                n7 = string2.indexOf(n5, n4);
            }
            n = new Integer(string2.substring(n4));
            if (n > 0) {
                return -1;
            }
            return 0;
        }
        n2 = new Integer(string.substring(n3, n6));
        if (n2 != (n = new Integer(string2.substring(n4)).intValue())) {
            return n2 - n;
        }
        n3 = n6 + 1;
        n6 = string.indexOf(n5, n3);
        while (n6 != -1) {
            n2 = new Integer(string.substring(n3, n6));
            if (n2 > 0) {
                return 1;
            }
            n3 = n6 + 1;
            n6 = string.indexOf(n5, n3);
        }
        n2 = new Integer(string.substring(n3));
        if (n2 > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void refresh() {
        if (this.netServiceHandler != null) {
            this.netServiceHandler.requestRefresh();
        }
        if (this.dbServiceHandler != null) {
            this.dbServiceHandler.requestRefresh();
        }
        if (this.serviceHandler != null) {
            this.serviceHandler.requestRefresh();
        }
        if (this.serviceAliasHandler != null) {
            this.serviceAliasHandler.requestRefresh();
        }
    }

    public boolean supportsAliases() throws DirectoryServiceException {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return false;
        }
        String string2 = this.config.getDS().query(this.config, "", "objectclass=*", "orclDirectoryVersion")[0];
        if ((string2 = string2.trim()).startsWith("OID ")) {
            string2 = string2.substring(4);
        }
        return LDAPDataStore.compareVersions(string2, "9.0.2") >= 0;
    }

    @Override
    public ServiceHandler getServiceHandler() throws DataStoreException {
        if (this.serviceHandler == null) {
            this.loadServiceHandler();
        }
        return this.serviceHandler;
    }

    @Override
    public NetServiceHandler getNetServiceHandler() throws DataStoreException {
        if (this.netServiceHandler == null) {
            this.loadNetServiceHandler();
        }
        return this.netServiceHandler;
    }

    @Override
    public DBServiceHandler getDBServiceHandler() throws DataStoreException {
        if (this.dbServiceHandler == null) {
            this.loadDBServiceHandler();
        }
        return this.dbServiceHandler;
    }

    @Override
    public ServiceAliasHandler getServiceAliasHandler() throws DataStoreException {
        if (this.serviceAliasHandler == null) {
            this.loadServiceAliasHandler();
        }
        return this.serviceAliasHandler;
    }

    public String toString() {
        return "LDAPDataStore [svr: " + this.config.getDirectoryServers(true)[0] + ", type: " + this.config.getDirectoryType() + ", ctxt: " + ORACLE_SOFTWARE_RDN + "," + this.config.namingContext(true) + ", home: " + this.config.OraHomeDir + "]";
    }

    public void setOracleContext(String string) {
        this.setOracleContext(string, true);
    }

    public void setOracleContext(String string, boolean bl) {
        this.config.setDefaultOracleContext(string);
        if (bl) {
            this.refresh();
        }
    }

    public String getDirectoryType() {
        return this.config.getDirectoryType();
    }

    public String[] getDirectoryServers() {
        return this.config.getDirectoryServers(true);
    }

    public String getOracleContext() {
        return this.config.getDefaultOracleContext(false);
    }

    public String getConnectionTimeout() {
        return this.config.getConnectionTimeout();
    }

    public int getAuthType() {
        return this.m_authType;
    }

    public String[] getCredentials() {
        return this.m_credentials;
    }

    public void disConnect() {
        this.config.unbind();
        this.m_authenticated = false;
    }

    public void setAuthInfo(int n, String[] stringArray) throws DataStoreException {
        try {
            this.config.getDS().setAuthInfo(n, stringArray);
            this.config.bind(n, stringArray);
            this.m_authType = n;
            this.m_credentials = stringArray;
            this.m_authenticated = true;
        }
        catch (ConfigException configException) {
            String string = configException.errno == 6 ? "authentication error" : (configException.errno == 5 ? "directory server error" : "unknown error");
            throw new DataStoreException(string, configException);
        }
    }

    public boolean isAuthenticated() {
        return this.m_authenticated;
    }

    public String[] getAlternateServers(String string, String string2) {
        return Config.getAlternateServers(string, string2);
    }

    public String[] getNamingContexts(String string, String string2) {
        return Config.getNamingContexts(string, string2);
    }

    public String[] getOracleContexts(String string, String string2, String string3) {
        String[] stringArray;
        int n;
        int n2 = n = this.m_authType != -1 ? this.m_authType : 1;
        if (this.m_credentials != null) {
            stringArray = this.m_credentials;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = "";
        }
        String[] stringArray3 = stringArray;
        if (this.config != null) {
            return this.config.getOracleContexts(string);
        }
        return Config.getOracleSoftware(string, n, stringArray3, string2, string3);
    }

    public String[] getSubContexts(String string, String string2, String string3) {
        return Config.getSubContexts(string, string2, string3);
    }

    public String detectDSType(String string) {
        return Config.detectDSType(string);
    }

    public String getCN(String string) {
        return this.config.getDS().getCN(string);
    }

    public String getCN(String string, boolean bl) {
        return this.config.getDS().getCN(string, bl);
    }

    String toDNSFromDN(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = this.config.getDS().explodeDN(string, true);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(stringArray[0]);
                continue;
            }
            stringBuffer.append("." + stringArray[i]);
        }
        return stringBuffer.toString();
    }

    String addDNSDomain(String string) {
        if (string.endsWith(this.contextAsDomain)) {
            return string;
        }
        return string + "." + this.contextAsDomain;
    }

    String stripDNSDomain(String string) {
        if (string.endsWith(this.contextAsDomain)) {
            return string.substring(0, string.lastIndexOf(this.contextAsDomain) - 1);
        }
        return string;
    }

    private void loadServiceHandler() throws DataStoreException {
        this.serviceHandler = new LDAPServiceHandler(this);
    }

    private void loadDBServiceHandler() throws DataStoreException {
        this.dbServiceHandler = new LDAPDBServiceHandler(this);
    }

    private void loadNetServiceHandler() throws DataStoreException {
        this.netServiceHandler = new LDAPNetServiceHandler(this);
    }

    private void loadServiceAliasHandler() throws DataStoreException {
        this.serviceAliasHandler = new LDAPServiceAliasHandler(this);
    }

    public void finalize() {
        this.config.unbind();
    }
}

