/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Vector;
import oracle.net.common.dataStore.DBServiceHandler;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.LDAPDataStore;
import oracle.net.common.netObject.DBService;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.config.DatabaseService;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAliasException;

public class LDAPDBServiceHandler
extends DBServiceHandler {
    private LDAPDataStore lds;

    LDAPDBServiceHandler(LDAPDataStore lDAPDataStore) {
        super(false);
        this.lds = lDAPDataStore;
    }

    @Override
    public void save() throws DataStoreException {
        if (!this.removeLog.isEmpty()) {
            try {
                int n = this.removeLog.size();
                for (int i = 0; i < n; ++i) {
                    DatabaseService.delete(this.lds.config, this.removeLog.elementAt(i).toString());
                }
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while removing DBService from LDAP" + this.lds, exception);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                DatabaseService databaseService = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[2];
                nArray[0] = 2;
                nArray[1] = 3;
                int[] nArray2 = nArray;
                DBService dBService = null;
                int n = this.changeLog.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.changeLog.elementAt(i).toString();
                    Object v = this.table.get(string);
                    if (!(v instanceof DBService)) {
                        throw new DataStoreException("Exception saving DBService to: " + this.lds + ", data error." + string + " = " + dBService);
                    }
                    dBService = (DBService)v;
                    databaseService = new DatabaseService(this.lds.config, string);
                    vector.removeAllElements();
                    NetService netService = dBService.getNetService();
                    if (netService != null) {
                        vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray2));
                    }
                    if (vector.size() == 0) {
                        databaseService.remEndpoints();
                    } else {
                        databaseService.setEndpoints(vector);
                    }
                    databaseService.systemName = dBService.getSystemName();
                    databaseService.serviceType = dBService.getServiceType();
                    databaseService.oracleHome = dBService.getOracleHome();
                    databaseService.sid = dBService.getSID();
                    databaseService.save(this.lds.config, true);
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
            }
            catch (ServiceAliasException serviceAliasException) {
                throw new DataStoreException("error writing DBService to: " + this.lds, serviceAliasException);
            }
            catch (SOExceptionConfig sOExceptionConfig) {
                throw new DataStoreException("error saving to: " + this.lds, sOExceptionConfig);
            }
        }
    }

    @Override
    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = DatabaseService.enumServiceAliases(this.lds.config, null, true);
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.lds.config.getDS().getCN(stringArray[i], true);
                this.table.put(string, "NOT_LOADED");
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    @Override
    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        String string2 = null;
        NetService netService = null;
        DatabaseService databaseService = null;
        try {
            databaseService = new DatabaseService(this.lds.config, string);
            string2 = databaseService.toString();
            if (string2 != null) {
                netService = new NetService("(" + string + "=" + databaseService.toString() + ")");
            }
            return new DBService(string, databaseService.systemName, databaseService.oracleHome, databaseService.sid, databaseService.globalDBName, netService);
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }
}

