/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.io.File;
import java.util.Vector;
import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.common.netObject.NoConnectDataException;
import oracle.net.config.Config;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.nl.NLParamParser;

public class FileNetServiceHandler
extends NetServiceHandler {
    private static final String netServiceFileBase = "tnsnames.ora";
    private Config config;
    private FileDataStore fds;

    FileNetServiceHandler(FileDataStore fileDataStore) throws DataStoreException {
        super(true);
        this.fds = fileDataStore;
        try {
            this.config = new Config(NetGetEnv.getOracleHome(), 1, new String[]{null, null});
            if (fileDataStore.isFileData()) {
                this.config.setFilename(0, fileDataStore.getAdminDir() + netServiceFileBase);
            } else {
                this.config.setStream(0, fileDataStore.getStreamData());
            }
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
        this.config.netConfigUsesLDAP(false);
    }

    @Override
    public void save() throws DataStoreException {
        Object object;
        if (this.fds.isFileData()) {
            this.config.setFilename(0, this.fds.getAdminDir() + netServiceFileBase);
        }
        if (!this.removeLog.isEmpty()) {
            try {
                object = this.config.getNlpa(0);
                int n = this.removeLog.size();
                for (int i = 0; i < n; ++i) {
                    ((NLParamParser)object).removeNLPListElement(this.removeLog.elementAt(i).toString());
                }
                if (this.fds.isFileData()) {
                    if (((NLParamParser)object).getNLPListSize() > 0) {
                        ((NLParamParser)object).saveNLParams();
                    } else {
                        File file = new File(this.config.getFilename(0));
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                } else if (((NLParamParser)object).getNLPListSize() > 0) {
                    this.config.writeToStream(0, this.fds.getStreamOutput());
                } else {
                    this.config.deleteNlpa(0);
                }
            }
            catch (Exception exception) {
                if (this.fds.isFileData()) {
                    throw new DataStoreException("Exception while saving ServiceAlias to: " + this.fds.getAdminDir() + netServiceFileBase);
                }
                throw new DataStoreException("Exception while deleting ServiceAlias from stream");
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                object = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[2];
                nArray[0] = 2;
                nArray[1] = 3;
                int[] nArray2 = nArray;
                NetService netService = null;
                int n = this.changeLog.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.changeLog.elementAt(i).toString();
                    netService = (NetService)this.table.get(string);
                    if (netService == null) {
                        String string2 = "Exception saving NetService, " + string + " to ";
                        string2 = this.fds.isFileData() ? string2 + this.fds.getAdminDir() + netServiceFileBase : string2 + "stream";
                        string2 = string2 + ". Internal data error: item not found";
                        throw new DataStoreException(string2);
                    }
                    object = new ServiceAlias(this.config, string);
                    vector.removeAllElements();
                    vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray2));
                    ((ServiceAlias)object).setEndpoints(vector);
                    ((ServiceAlias)object).bufferedSave(this.config, true);
                }
                if (this.fds.isFileData()) {
                    this.config.getNlpa(0).saveNLParams();
                } else {
                    this.config.writeToStream(0, this.fds.getStreamOutput());
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
            }
            catch (Exception exception) {
                String string = "Exception saving NetService to ";
                string = this.fds.isFileData() ? string + this.fds.getAdminDir() + netServiceFileBase : string + "stream";
                string = string + ". " + exception.getMessage();
                throw new DataStoreException(string);
            }
        }
    }

    @Override
    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = ServiceAlias.enumServiceAliases(this.config, null, false);
            for (int i = 0; i < stringArray.length; ++i) {
                this.table.put(stringArray[i], "NOT_LOADED");
            }
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    @Override
    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        try {
            ServiceAlias serviceAlias = new ServiceAlias(this.config, string);
            return new NetService("(" + string + "=" + serviceAlias.toString() + ")");
        }
        catch (ServiceAliasException serviceAliasException) {
            if (serviceAliasException.errno == 8 && ((SOExceptionConfig)serviceAliasException.getNestedThrowable()).errno == 4) {
                throw new DataStoreException(4);
            }
            throw new DataStoreException(serviceAliasException);
        }
        catch (NoConnectDataException noConnectDataException) {
            throw new DataStoreException(4);
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }

    @Override
    public String[] enumDomains() throws DataStoreException {
        try {
            return ServiceAlias.enumDomains(this.config);
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    @Override
    public String[] enumConfigObjects(String string) throws DataStoreException {
        try {
            if (string.equals(".")) {
                return ServiceAlias.enumServiceAliases(this.config, ServiceAlias.NULL_DOMAIN, false);
            }
            return ServiceAlias.enumServiceAliases(this.config, string, false);
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }
}

