/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.io.File;
import java.io.Reader;
import java.io.Writer;
import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DataStore;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileNetServiceHandler;
import oracle.net.common.dataStore.NetServiceDataStorer;
import oracle.net.common.dataStore.NetServiceHandler;

public class FileDataStore
extends DataStore
implements NetServiceDataStorer {
    private String m_adminDir;
    private Reader m_streamData;
    private Writer m_streamOutput;
    private FileNetServiceHandler netServiceHandler;

    public FileDataStore() {
        this(NetGetEnv.getNetworkDir());
    }

    public FileDataStore(String string) {
        int n;
        this.m_streamData = null;
        this.m_streamOutput = null;
        this.m_adminDir = string;
        for (n = this.m_adminDir.length() - 1; n >= 0 && this.m_adminDir.charAt(n) == File.separatorChar; --n) {
        }
        this.m_adminDir = this.m_adminDir.substring(0, n + 1) + File.separatorChar;
    }

    public FileDataStore(Reader reader) {
        this.m_adminDir = null;
        this.m_streamData = reader;
        this.m_streamOutput = null;
    }

    public boolean isFileData() {
        return this.m_adminDir != null;
    }

    public String getAdminDir() {
        return this.m_adminDir;
    }

    public Reader getStreamData() {
        return this.m_streamData;
    }

    public void setStreamOutput(Writer writer) {
        this.m_streamOutput = writer;
    }

    public Writer getStreamOutput() {
        return this.m_streamOutput;
    }

    @Override
    public NetServiceHandler getNetServiceHandler() throws DataStoreException {
        if (this.netServiceHandler == null) {
            this.loadNetServiceHandler();
        }
        return this.netServiceHandler;
    }

    @Override
    public void refresh() {
        if (this.netServiceHandler != null) {
            this.netServiceHandler.requestRefresh();
        }
    }

    public String toString() {
        return "FileDataStore [dir: " + this.getAdminDir() + "]";
    }

    private void loadNetServiceHandler() throws DataStoreException {
        this.netServiceHandler = new FileNetServiceHandler(this);
    }
}

