/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class VIAddress
extends Address {
    public static String VI_PROTOCOL = "VI";

    protected VIAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = VIAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(VI_PROTOCOL)) {
            throw new CreateAddressException("VI: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(VI_PROTOCOL);
        String string2 = Address._getParameter(nVPair, "HOST");
        if (string2 == null) {
            throw new CreateAddressException("VI: The value for the HOST is missing.");
        }
        this.setHost(string2);
        String string3 = Address._getParameter(nVPair, "DISC");
        if (string3 == null) {
            throw new CreateAddressException("VI: The value for Discriminator is missing.");
        }
        try {
            this.setDisc(Integer.valueOf(string3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("VI: The value for Discriminator (" + string3 + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getDisc() {
        String string = this._getParameter("DISC");
        return Integer.valueOf(string);
    }

    public void setHost(String string) {
        VIAddress._validateHost(string);
        this._setParameter("HOST", string);
    }

    public void setDisc(int n) {
        VIAddress._validateDisc(n);
        this._setParameter("DISC", String.valueOf(n));
    }

    private static void _validateHost(String string) {
    }

    private static void _validateDisc(int n) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        VIAddress vIAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        VIAddress._print("Verifying constructor VIAddress(nvp)");
        VIAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=VI)(HOST=WINTER)(DISC=1521))";
            VIAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      Result: " + vIAddress.toNVString());
            string = "(Address = (Host = summer) (DISC = 1526) (Protocol = vi))";
            VIAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      Result: " + vIAddress.toNVString());
            string = "(address = (protocol = vi) (disc = 5000) (host = spring))";
            VIAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      Result: " + vIAddress.toNVString());
        }
        catch (NLException nLException) {
            VIAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        VIAddress._print("\n  With INVALID input");
        try {
            string = "(address = (host=winter)(disc=1521))";
            VIAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            VIAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(service = winter_lsnr))";
            VIAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            VIAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(disc=1521))";
            VIAddress._print("    Case 3: Missing host: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            VIAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(host=summer))";
            VIAddress._print("    Case 4: Missing disc: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            VIAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(host=summer)(disc=1521)";
            VIAddress._print("    Case 5: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            VIAddress._print("      Exception Received: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(host=summer)(disc=foo))";
            VIAddress._print("    Case 6: Invalid disc: " + string);
            nVPair = nVFactory.createNVPair(string);
            vIAddress = new VIAddress(nVPair);
            VIAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            VIAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            VIAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
    }
}

