/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TCPSAddress
extends Address {
    public static String TCPS_PROTOCOL = "TCPS";

    protected TCPSAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = TCPSAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(TCPS_PROTOCOL)) {
            throw new CreateAddressException("TCPS: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(TCPS_PROTOCOL);
        String string2 = Address._getParameter(nVPair, "HOST");
        if (string2 == null) {
            throw new CreateAddressException("TCPS: The value for the HOST is missing.");
        }
        this.setHost(string2);
        String string3 = Address._getParameter(nVPair, "PORT");
        if (string3 == null) {
            throw new CreateAddressException("TCPS: The value for PORT is missing.");
        }
        try {
            this.setPort(Integer.valueOf(string3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("TCPS: The value for PORT (" + string3 + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getPort() {
        String string = this._getParameter("PORT");
        return Integer.valueOf(string);
    }

    public void setHost(String string) {
        TCPSAddress._validateHost(string);
        this._setParameter("HOST", string);
    }

    public void setPort(int n) {
        TCPSAddress._validatePort(n);
        this._setParameter("PORT", String.valueOf(n));
    }

    private static void _validateHost(String string) {
    }

    private static void _validatePort(int n) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        TCPSAddress tCPSAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        TCPSAddress._print("Verifying constructor TCPSAddress(nvp)");
        TCPSAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=TCPS)(HOST=WINTER)(PORT=1521))";
            TCPSAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      Result: " + tCPSAddress.toNVString());
            string = "(Address = (Host = summer) (Port = 1526) (Protocol = TCPS))";
            TCPSAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      Result: " + tCPSAddress.toNVString());
            string = "(address = (protocol = TCPS) (port = 5000) (host = spring))";
            TCPSAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      Result: " + tCPSAddress.toNVString());
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        TCPSAddress._print("\n  With INVALID input");
        try {
            string = "(address = (host=winter)(port=1521))";
            TCPSAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(service = winter_lsnr))";
            TCPSAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=TCPS)(port=1521))";
            TCPSAddress._print("    Case 3: Missing host: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=TCPS)(host=summer))";
            TCPSAddress._print("    Case 4: Missing port: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=TCPS)(host=summer)(port=1521)";
            TCPSAddress._print("    Case 5: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=TCPS)(host=summer)(port=foo))";
            TCPSAddress._print("    Case 6: Invalid port: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPSAddress = new TCPSAddress(nVPair);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            TCPSAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
    }
}

