/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TCPAddress
extends Address {
    public static String TCP_PROTOCOL = "TCP";

    protected TCPAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = TCPAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(TCP_PROTOCOL)) {
            throw new CreateAddressException("TCP/IP: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(TCP_PROTOCOL);
        String string2 = Address._getParameter(nVPair, "HOST");
        if (string2 == null) {
            throw new CreateAddressException("TCP/IP: The value for the HOST is missing.");
        }
        this.setHost(string2);
        String string3 = Address._getParameter(nVPair, "PORT");
        if (string3 == null) {
            throw new CreateAddressException("TCP/IP: The value for PORT is missing.");
        }
        try {
            this.setPort(Integer.valueOf(string3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("TCP/IP: The value for PORT (" + string3 + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getPort() {
        String string = this._getParameter("PORT");
        return Integer.valueOf(string);
    }

    public void setHost(String string) {
        TCPAddress._validateHost(string);
        this._setParameter("HOST", string);
    }

    public void setPort(int n) {
        TCPAddress._validatePort(n);
        this._setParameter("PORT", String.valueOf(n));
    }

    private static void _validateHost(String string) {
    }

    private static void _validatePort(int n) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        TCPAddress tCPAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        TCPAddress._print("Verifying constructor TCPAddress(nvp)");
        TCPAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=TCP)(HOST=WINTER)(PORT=1521))";
            TCPAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      Result: " + tCPAddress.toNVString());
            string = "(Address = (Host = summer) (Port = 1526) (Protocol = tcp))";
            TCPAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      Result: " + tCPAddress.toNVString());
            string = "(address = (protocol = tcp) (port = 5000) (host = spring))";
            TCPAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      Result: " + tCPAddress.toNVString());
        }
        catch (NLException nLException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        TCPAddress._print("\n  With INVALID input");
        try {
            string = "(address = (host=winter)(port=1521))";
            TCPAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(service = winter_lsnr))";
            TCPAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(port=1521))";
            TCPAddress._print("    Case 3: Missing host: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=summer))";
            TCPAddress._print("    Case 4: Missing port: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=summer)(port=1521)";
            TCPAddress._print("    Case 5: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            TCPAddress._print("      Exception Received: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=summer)(port=foo))";
            TCPAddress._print("    Case 6: Invalid port: " + string);
            nVPair = nVFactory.createNVPair(string);
            tCPAddress = new TCPAddress(nVPair);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            TCPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            TCPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
    }
}

