/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class SDPAddress
extends Address {
    public static String SDP_PROTOCOL = "SDP";

    protected SDPAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = SDPAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(SDP_PROTOCOL)) {
            throw new CreateAddressException("SDP: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(SDP_PROTOCOL);
        String string2 = Address._getParameter(nVPair, "HOST");
        if (string2 == null) {
            throw new CreateAddressException("SDP: The value for the HOST is missing.");
        }
        this.setHost(string2);
        String string3 = Address._getParameter(nVPair, "PORT");
        if (string3 == null) {
            throw new CreateAddressException("SDP: The value for PORT is missing.");
        }
        try {
            this.setPort(Integer.valueOf(string3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("SDP: The value for PORT (" + string3 + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getPort() {
        String string = this._getParameter("PORT");
        return Integer.valueOf(string);
    }

    public void setHost(String string) {
        SDPAddress._validateHost(string);
        this._setParameter("HOST", string);
    }

    public void setPort(int n) {
        SDPAddress._validatePort(n);
        this._setParameter("PORT", String.valueOf(n));
    }

    private static void _validateHost(String string) {
    }

    private static void _validatePort(int n) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        SDPAddress sDPAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        SDPAddress._print("Verifying constructor SDPAddress(nvp)");
        SDPAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=SDP)(HOST=WINTER)(PORT=1521))";
            SDPAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      Result: " + sDPAddress.toNVString());
            string = "(Address = (Host = summer) (Port = 1526) (Protocol = SDP))";
            SDPAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      Result: " + sDPAddress.toNVString());
            string = "(address = (protocol = SDP) (port = 5000) (host = spring))";
            SDPAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      Result: " + sDPAddress.toNVString());
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        SDPAddress._print("\n  With INVALID input");
        try {
            string = "(address = (host=winter)(port=1521))";
            SDPAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(service = winter_lsnr))";
            SDPAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=SDP)(port=1521))";
            SDPAddress._print("    Case 3: Missing host: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=SDP)(host=summer))";
            SDPAddress._print("    Case 4: Missing port: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=SDP)(host=summer)(port=1521)";
            SDPAddress._print("    Case 5: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        try {
            string = "(address = (protocol=SDP)(host=summer)(port=foo))";
            SDPAddress._print("    Case 6: Invalid port: " + string);
            nVPair = nVFactory.createNVPair(string);
            sDPAddress = new SDPAddress(nVPair);
            SDPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            SDPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            SDPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
    }
}

