/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class NMPAddress
extends Address {
    public static String NMP_PROTOCOL = "NMP";

    public NMPAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = NMPAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(NMP_PROTOCOL)) {
            throw new CreateAddressException("NMP: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(NMP_PROTOCOL);
        String string2 = Address._getParameter(nVPair, "SERVER");
        if (string2 == null) {
            throw new CreateAddressException("NMP: The value for SERVER is missing.");
        }
        this.setServer(string2);
        String string3 = Address._getParameter(nVPair, "PIPE");
        if (string3 == null) {
            throw new CreateAddressException("NMP: The value for PIPE is missing.");
        }
        this.setPipe(string3);
    }

    public String getServer() {
        return this._getParameter("SERVER");
    }

    public String getPipe() {
        return this._getParameter("PIPE");
    }

    public void setServer(String string) {
        NMPAddress._validateServer(string);
        this._setParameter("SERVER", string);
    }

    public void setPipe(String string) {
        NMPAddress._validatePipe(string);
        this._setParameter("PIPE", string);
    }

    private static void _validateServer(String string) {
    }

    private static void _validatePipe(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        NMPAddress nMPAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        NMPAddress._print("Verifying constructor NMPAddress(nvp)");
        NMPAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=NMP)(SERVER=WINTER)(PIPE=ORAPIPE))";
            NMPAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      Result: " + nMPAddress.toNVString());
            string = "(Address = (Server = Summer) (PIPE = ORAPIPE) (Protocol = NMP))";
            NMPAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      Result: " + nMPAddress.toNVString());
            string = "(address = (protocol = nmp) (pipe = orapipe) (server = stacks))";
            NMPAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      Result: " + nMPAddress.toNVString());
        }
        catch (NLException nLException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        NMPAddress._print("\n  With INVALID input");
        try {
            string = "(address = (server=summer)(pipe=orapipe))";
            NMPAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            NMPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(service = winter_lsnr))";
            NMPAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            NMPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=nmp)(pipe=orapipe))";
            NMPAddress._print("    Case 3: Missing server: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            NMPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=nmp)(server=summer))";
            NMPAddress._print("    Case 4: Missing pipe: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            NMPAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=nmp)(server=summer)(pipe=orapipe)";
            NMPAddress._print("    Case 5: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            nMPAddress = new NMPAddress(nVPair);
            NMPAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            NMPAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            NMPAddress._print("      Exception Received: " + nLException.getMessage());
        }
    }
}

