/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class IPCAddress
extends Address {
    public static String IPC_PROTOCOL = "IPC";

    protected IPCAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = IPCAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(IPC_PROTOCOL)) {
            throw new CreateAddressException("IPC: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(IPC_PROTOCOL);
        String string2 = Address._getParameter(nVPair, "KEY");
        if (string2 == null) {
            throw new CreateAddressException("IPC: The value for KEY is missing.");
        }
        this.setKey(string2);
    }

    public String getKey() {
        return this._getParameter("KEY");
    }

    public void setKey(String string) {
        IPCAddress._validateKey(string);
        this._setParameter("KEY", string);
    }

    private static void _validateKey(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        IPCAddress iPCAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        IPCAddress._print("Verifying constructor IPCAddress(nvp)");
        IPCAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=IPC)(KEY=winter_lsnr))";
            IPCAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      Result: " + iPCAddress.toNVString());
            string = "(Address = (key = summer_lsnr) (protocol = ipc))";
            IPCAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      Result: " + iPCAddress.toNVString());
            string = "(address = (Protocol = IPC) (Key = novell1))";
            IPCAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      Result: " + iPCAddress.toNVString());
        }
        catch (NLException nLException) {
            IPCAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            IPCAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        IPCAddress._print("\n  With INVALID input");
        try {
            string = "(address = (key=foobar))";
            IPCAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            IPCAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            IPCAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=winter)(port=1521))";
            IPCAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            IPCAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            IPCAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=ipc))";
            IPCAddress._print("    Case 3: Missing service: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            IPCAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            IPCAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=ipc)(key=summer_lsnr)";
            IPCAddress._print("    Case 4: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            iPCAddress = new IPCAddress(nVPair);
            IPCAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            IPCAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            IPCAddress._print("      Exception Received: " + nLException.getMessage());
        }
    }
}

