/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class BEQAddress
extends Address {
    public static String BEQ_PROTOCOL = "BEQ";

    protected BEQAddress(NVPair nVPair) throws CreateAddressException {
        super(nVPair);
        String string = BEQAddress._getParameter(nVPair, "PROTOCOL");
        if (string == null || !string.equalsIgnoreCase(BEQ_PROTOCOL)) {
            throw new CreateAddressException("Bequeath: Invalid protocol (" + string + ") in Address.");
        }
        this._setProtocol(BEQ_PROTOCOL);
        this.setSID("ORCL");
    }

    public String getSID() {
        String string = this._getParameter("ARGV0");
        String string2 = string.substring(8);
        return string2;
    }

    public void setSID(String string) {
        BEQAddress._validateSID(string);
        this._setParameter("PROGRAM", "oracle80");
        this._setParameter("ARGV0", "oracle80" + string);
        this._setParameter("ARGS", "'(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=BEQ)))'");
    }

    private static void _validateSID(String string) {
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        BEQAddress bEQAddress;
        NVPair nVPair;
        String string;
        NVFactory nVFactory = new NVFactory();
        BEQAddress._print("Verifying constructor BEQAddress(nvp)");
        BEQAddress._print("  With VALID input");
        try {
            string = "(ADDRESS=(PROTOCOL=BEQ)(ARGV0=oracle73ORCL))";
            BEQAddress._print("    Case 1: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      Result: " + bEQAddress.toNVString());
            string = "(Address = (ARGV0=oracle80EM1) (protocol = BEQ))";
            BEQAddress._print("    Case 2: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      Result: " + bEQAddress.toNVString());
            string = "(address = (Protocol = BEQ) (argv0 = oracle80Tst))";
            BEQAddress._print("    Case 3: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      Result: " + bEQAddress.toNVString());
        }
        catch (NLException nLException) {
            BEQAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            BEQAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        BEQAddress._print("\n  With INVALID input");
        try {
            string = "(address = (argv0 = oracle80orcl))";
            BEQAddress._print("    Case 1: Missing protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            BEQAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            BEQAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=winter)(port=1521))";
            BEQAddress._print("    Case 2: Incorrect protocol: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            BEQAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            BEQAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=BEQ))";
            BEQAddress._print("    Case 3: Missing ARGV0: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (NLException nLException) {
            BEQAddress._print("      ERROR: Unexpected exception: " + nLException.getMessage());
        }
        catch (CreateAddressException createAddressException) {
            BEQAddress._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=BEQ)(argv0 = oracle80orcl)";
            BEQAddress._print("    Case 4: Parse error: " + string);
            nVPair = nVFactory.createNVPair(string);
            bEQAddress = new BEQAddress(nVPair);
            BEQAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException createAddressException) {
            BEQAddress._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        catch (NLException nLException) {
            BEQAddress._print("      Exception Received: " + nLException.getMessage());
        }
    }
}

