/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.addr;

import oracle.net.common.addr.Address;
import oracle.net.common.addr.CreateAddressException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class AddressFactory {
    private static AddressFactory _sfactory = null;

    public static void loadClass() {
    }

    private AddressFactory() {
    }

    public static AddressFactory getFactory() {
        if (_sfactory == null) {
            _sfactory = new AddressFactory();
        }
        return _sfactory;
    }

    public Address createAddress(NVPair nVPair) throws CreateAddressException {
        if (nVPair == null) {
            throw new IllegalArgumentException("AddressFactory.createAddress(): NVPair nvp is null.");
        }
        if (nVPair.getRHSType() != NVPair.RHS_LIST) {
            throw new CreateAddressException("The ADDRESS section does not contain a list of parameters.");
        }
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "PROTOCOL");
        if (nVPair2 == null) {
            throw new CreateAddressException("A PROTOCOL could not be found for this Address.");
        }
        if (nVPair2.getRHSType() != NVPair.RHS_ATOM) {
            throw new CreateAddressException("The value for the PROTOCOL in the Address is invalid.");
        }
        return new Address(nVPair);
    }

    public Address createAddress(String string) throws CreateAddressException {
        NVPair nVPair = null;
        NVFactory nVFactory = new NVFactory();
        try {
            nVPair = nVFactory.createNVPair(string);
        }
        catch (NLException nLException) {
            System.err.println(nLException.getMessage());
        }
        Address address = this.createAddress(nVPair);
        return address;
    }

    private static void _print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        Address address;
        String string;
        AddressFactory addressFactory = AddressFactory.getFactory();
        AddressFactory._print("Verifying createAddress()");
        try {
            AddressFactory._print("  With VALID input: ");
            string = "(Address = (Protocol = TCPS) (Port = 1521) (Host = winter))";
            AddressFactory._print("    Case 0: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("      Result = " + address.toNVString());
            string = "(Address = (Protocol = TCP) (Port = 1521) (Host = winter))";
            AddressFactory._print("    Case 1: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("      Result = " + address.toNVString());
            string = "(Address = (Protocol = VI) (disc = 1521) (Host = winter))";
            AddressFactory._print("    Case 2: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("      Result = " + address.toNVString());
            string = "(ADDRESS=(PROTOCOl=NMP)(SERVER=winter)(PIPE=ORAPIPE))";
            AddressFactory._print("    Case 3: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("      Result = " + address.toNVString());
            string = "(ADDRESS=(PROTOCOl=BEQ)(ARGV0 = oracle73DEQ))";
            AddressFactory._print("    Case 4: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("      Result = " + address.toNVString());
            string = "(ADDRESS=(PROTOCOl=IPC)(KEY = oracle))";
            AddressFactory._print("    Case 5: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("      Result = " + address.toNVString());
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      ERROR: Unexpected exception: " + createAddressException.getMessage());
        }
        AddressFactory._print("\n  With INVALID input: ");
        try {
            string = "(ADDRESS=(PROTOCOl=IPC)(KEY=winter))";
            AddressFactory._print("    Case 1: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(ADDRESS=NONE)";
            AddressFactory._print("    Case 2: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(()()((())))";
            AddressFactory._print("    Case 3: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(Address=(Host=winter)(Port=1521))";
            AddressFactory._print("    Case 4: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(ADDRESS=(PROTOCOL=(A=B))(HOST=winter)(Port=1521))";
            AddressFactory._print("    Case 5: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(ADDRESS=)";
            AddressFactory._print("    Case 6: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        AddressFactory._print("\n  With PROTOCOL-specific INVALID input: ");
        try {
            string = "(address = (protocol=tcp)(port=1521))";
            AddressFactory._print("    Case 1: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=summer))";
            AddressFactory._print("    Case 2: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=summer)(port=1521)";
            AddressFactory._print("    Case 3: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=tcp)(host=summer)(port=foo))";
            AddressFactory._print("    Case 4: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)";
            AddressFactory._print("    Case 5: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=vi)(service=summer_lsnr)";
            AddressFactory._print("    Case 6: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=nmp)(pipe=orapipe))";
            AddressFactory._print("    Case 7: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=nmp)(server=summer))";
            AddressFactory._print("    Case 8: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
        try {
            string = "(address = (protocol=nmp)(server=summer)(pipe=orapipe)";
            AddressFactory._print("    Case 9: " + string);
            address = addressFactory.createAddress(string);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException createAddressException) {
            AddressFactory._print("      Exception Received: " + createAddressException.getMessage());
        }
    }
}

