/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common;

public class OracleJNI {
    private static final String libraryVersionNumber = "12";

    public static void loadJniLibrary(String string) {
        String string2 = OracleJNI.getLibraryNameFromStem(string);
        try {
            System.loadLibrary(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("UnsatisfiedLinkError exception loading native library: " + string2);
            System.out.println(unsatisfiedLinkError.toString());
        }
    }

    public static String getLibraryNameFromStem(String string) {
        String string2 = string + libraryVersionNumber;
        if (System.getProperty("os.name", "DEFAULT").startsWith("Windows")) {
            string2 = "ora" + string2;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        String string = OracleJNI.getLibraryNameFromStem("foobar");
        boolean bl = false;
        if (System.getProperty("os.name", "DEFAULT").startsWith("Windows")) {
            if (string.equals("orafoobar12")) {
                bl = true;
            }
        } else if (string.equals("foobar12")) {
            bl = true;
        }
        System.out.println("getLibraryNameFromStem given: foobar");
        System.out.println("  getLibraryNameFromStem returned: " + string);
        if (bl) {
            System.out.println("  Test Passed.");
        } else {
            System.out.println("  Test Failed.");
        }
        System.out.println("loadJNILibrary given: foobar");
        OracleJNI.loadJniLibrary("foobar");
        System.out.println("  Test Passed if link error message produced.");
        System.out.println("loadJNILibrary given: njni");
        OracleJNI.loadJniLibrary("njni");
        System.out.println("  Test Passed if no error message produced.");
    }
}

