/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import oracle.net.common.NetGetEnv;

public class NetProperties {
    private static final char SEP = File.separatorChar;
    private static final String INSTALLED_PRODUCTS = "%s_netCAInstalledProducts%";
    private static NetProperties instance;
    private Properties netProperties = new Properties();
    private FileInputStream inpFile;
    private String fileName = NetGetEnv.getOracleHome();

    public static NetProperties getInstance() throws FileNotFoundException, IOException {
        if (instance == null) {
            instance = new NetProperties();
        }
        return instance;
    }

    private NetProperties() throws FileNotFoundException, IOException {
        int n;
        for (n = this.fileName.length() - 1; n >= 0 && this.fileName.charAt(n) == SEP; --n) {
        }
        this.fileName = this.fileName.substring(0, n + 1) + SEP + "network" + SEP + "tools" + SEP + "NetProperties";
        this.inpFile = new FileInputStream(this.fileName);
        this.netProperties.load(this.inpFile);
    }

    public String getProperty(String string) {
        String string2 = this.netProperties.getProperty(string);
        if (string2 != null && string2.indexOf(INSTALLED_PRODUCTS) >= 0) {
            return null;
        }
        return string2;
    }

    public void putProperty(String string, String string2) {
        this.netProperties.put(string, string2);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void save() throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
        this.netProperties.save(fileOutputStream, null);
    }
}

