/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import oracle.ops.mgmt.has.AlreadyExistsException;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASDebug;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.has.NetInterfaceNotFoundException;
import oracle.ops.mgmt.has.NodeNotFoundException;
import oracle.ops.mgmt.has.VIPException;
import oracle.ops.mgmt.has.VIPNative;
import oracle.ops.mgmt.has.VIPNativeResult;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.trace.Trace;

public class VIP {
    private HASContext m_ctx;
    private Object m_ref = new Object();

    public VIP() throws VIPException {
        int moduleInit = 32;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException hce) {
            throw new VIPException(NLSMessage.getHASInitFailed(), (Exception)((Object)hce));
        }
        Trace.out((String)"VIP Instance created.");
    }

    public void destroy() throws VIPException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new VIPException(t.toString());
        }
    }

    protected void finalize() throws Throwable {
        Trace.out((String)("VIP: finalized called for " + this));
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    private void assertCtxNotNull() throws VIPException {
        HASDebug.assertFunc(this, this.m_ctx != null, "ClusterAlias: ctx is null");
    }

    private void handleUnexpectedException(HASContextException hce) throws VIPException {
        throw new VIPException(hce.getMessage(), (Exception)((Object)hce));
    }

    public void create(String vipName, String ip, String nodeName, String netMask) throws VIPException, IllegalArgumentException, NodeNotFoundException, AlreadyExistsException {
        this.createVIP(vipName, ip, nodeName, netMask, null);
    }

    public void create(String vipName, String ip, String nodeName, String netMask, String[] interfaces) throws VIPException, IllegalArgumentException, NodeNotFoundException, AlreadyExistsException {
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException(NLSMessage.getIllegalNullArgumentErrorMessage("interfaces"));
        }
        this.createVIP(vipName, ip, nodeName, netMask, interfaces);
    }

    private void createVIP(String vipName, String ip, String nodeName, String netMask, String[] interfaces) throws VIPException, IllegalArgumentException, NodeNotFoundException, AlreadyExistsException {
        HASDebug.assertStringArgument(vipName, "vipName");
        HASDebug.assertStringArgument(ip, "ip");
        HASDebug.assertStringArgument(nodeName, "nodeName");
        HASDebug.assertStringArgument(netMask, "netMask");
        this.assertCtxNotNull();
        try {
            this.m_ctx.createVIP(vipName, ip, nodeName, netMask, interfaces);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
        }
    }

    public void delete(String vipName) throws VIPException, IllegalArgumentException, VIPNotFoundException {
        HASDebug.assertStringArgument(vipName, "vipName");
        this.assertCtxNotNull();
        try {
            this.m_ctx.deleteVIP(vipName);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
        }
    }

    public String[] listInterfaces() throws VIPException, IllegalArgumentException, NetInterfaceNotFoundException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.listInterfaces();
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
            return null;
        }
    }

    public String[] listInterfacesEx() throws VIPException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.listInterfacesEx();
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
            return null;
        }
    }

    public String getNetMask(String netIF) throws VIPException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.getNetMask(netIF);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterfacesPrivate(String[] interfaces) throws VIPException {
        boolean isPrivate = false;
        this.assertCtxNotNull();
        try {
            VIPNativeResult result = new VIPNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                isPrivate = VIPNative.isInterfacesPrivate(result, interfaces);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
            return isPrivate;
        }
        return isPrivate;
    }
}

