/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.ops.mgmt.has.GroupNotFoundException;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASDebug;
import oracle.ops.mgmt.has.HASException;
import oracle.ops.mgmt.has.HASNativeResult;
import oracle.ops.mgmt.has.InsufficientPrivilegeException;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.has.NotFoundException;
import oracle.ops.mgmt.has.UserNotFoundException;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.UtilNative;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class Util {
    private static final String NULLSID = "NULLSID";
    private HASContext m_ctx;
    private Object m_ref = new Object();

    public Util() throws UtilException {
        int moduleInit = 6;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException hce) {
            throw new UtilException(NLSMessage.getHASInitFailed(), (Exception)((Object)hce));
        }
        Trace.out((String)"Util Instance created.");
    }

    public void destroy() throws UtilException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new UtilException(t.toString());
        }
    }

    protected void finalize() throws Throwable {
        Trace.out((String)("Util: finalized called for " + this));
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    private void assertCtxNotNull() throws UtilException {
        HASDebug.assertFunc(this, this.m_ctx != null, "Util: m_ctx is null");
    }

    private void handleUnexpectedException(HASContextException hce) throws UtilException {
        throw new UtilException(hce.getMessage(), (Exception)((Object)hce));
    }

    public String getOracleUser(String oracleHome, String oracleSID) throws UtilException, UserNotFoundException {
        File f;
        HASDebug.assertStringArgument(oracleHome, "oracleHome");
        this.assertCtxNotNull();
        if (oracleSID == null) {
            oracleSID = NULLSID;
        }
        if (!(f = new File(oracleHome)).exists() || !f.isDirectory()) {
            throw new UtilException(NLSMessage.getNoSuchOracleHome(oracleHome));
        }
        try {
            return this.m_ctx.getOracleUser(oracleHome, oracleSID);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    public String getOracleGroup(String oracleHome) throws UtilException, GroupNotFoundException {
        HASDebug.assertStringArgument(oracleHome, "oracleHome");
        this.assertCtxNotNull();
        File f = new File(oracleHome);
        if (!f.exists() || !f.isDirectory()) {
            throw new UtilException(NLSMessage.getNoSuchOracleHome(oracleHome));
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        try {
            return nativeSystem.getOracleGroup(oracleHome);
        }
        catch (NativeException hasce) {
            throw new GroupNotFoundException(hasce.getMessage());
        }
    }

    public boolean isGroupMember(String userName, String groupName) throws UtilException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.isGroupMember(userName, groupName);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDaemon(String exePath, String[] input, String[] env) throws UtilException {
        HASException re = null;
        this.assertCtxNotNull();
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                UtilNative.makeDaemon(result, exePath, input, env);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException exp) {
            re = exp;
        }
        catch (UtilException exp) {
            re = exp;
        }
        if (null != re) {
            throw new UtilException(this.m_ctx.getNLSMessage("1015", new String[]{exePath, Utils.getString((String[])input, (String)" "), Utils.getString((String[])env, (String)" "), re.getMessage()}), (Exception)((Object)re));
        }
    }

    public String getCurrentUser() throws UtilException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.getCurrentUser();
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    public String getCurrentUserPrimaryGroup() throws UtilException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.getCurrentUserPrimaryGroup();
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    public String getPrimaryGroup(String userName) throws UtilException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.getPrimaryGroup(userName);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    public boolean hasHAPrivilege() throws UtilException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.hasHAPrivilege();
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    public void checkOracleUser(String orclHome) throws UtilException {
        this.checkOracleUser(orclHome, false);
    }

    public void checkOracleUser(String orclHome, boolean always) throws UtilException {
        if (always || !this.hasHAPrivilege()) {
            String oUser = this.getOracleUser(orclHome, null);
            String myUser = this.getCurrentUser();
            if (myUser != null && !myUser.equalsIgnoreCase(oUser)) {
                throw new UtilException(NLSMessage.getMisMatchOracleUser(myUser, oUser, orclHome));
            }
        }
    }

    public void checkOracleUser(String orclHome, String ocrKeyOwner) throws UtilException {
        String myUser;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (new File(orclHome + File.separator + "bin" + File.separator + nativeSystem.getExeName("oracle")).exists()) {
            this.checkOracleUser(orclHome);
        } else if (!this.hasHAPrivilege() && (myUser = this.getCurrentUser()) != null && !myUser.equalsIgnoreCase(ocrKeyOwner)) {
            throw new UtilException(NLSMessage.getMisMatchOracleUser(myUser, ocrKeyOwner, orclHome));
        }
    }

    public void becomeOracleUser(String oracleHome, String oracleSID) throws UtilException, InsufficientPrivilegeException, UserNotFoundException, IllegalArgumentException {
        HASDebug.assertStringArgument(oracleHome, "oracleHome");
        this.assertCtxNotNull();
        if (oracleSID == null) {
            oracleSID = NULLSID;
        }
        try {
            this.m_ctx.becomeOracleUser(oracleHome, oracleSID);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    public void revertToHAPrivilegedUser() throws UtilException, InsufficientPrivilegeException {
        this.assertCtxNotNull();
        try {
            if (!this.hasHAPrivilege()) {
                this.m_ctx.becomeHAPrivilegedUser();
            }
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    public String getCRSUser() throws UtilException, NotFoundException, UserNotFoundException {
        String home = this.getCRSHome();
        Trace.out((String)("getCRSHome: ret=" + home));
        return this.getOracleUser(home, null);
    }

    public String getCRSHome() throws UtilException, NotFoundException {
        this.assertCtxNotNull();
        try {
            String home = this.m_ctx.getCRSHome();
            Trace.out((String)("getCRSHome: ret=" + home));
            return home;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxServices() throws UtilException {
        this.assertCtxNotNull();
        try {
            HASNativeResult result = new HASNativeResult();
            int maxsvcs = 0;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                maxsvcs = UtilNative.getMaxServices(result);
            }
            this.m_ctx.checkResult(result);
            return maxsvcs;
        }
        catch (HASContextException e) {
            throw new UtilException(e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalHostName() throws UtilException {
        this.assertCtxNotNull();
        try {
            HASNativeResult result = new HASNativeResult();
            String localHost = null;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                localHost = UtilNative.getLocalHostName(result);
            }
            this.m_ctx.checkResult(result);
            return localHost;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToAlertLog(int msgNumber, String arg) throws UtilException {
        this.assertCtxNotNull();
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                UtilNative.writeToAlertLog(result, msgNumber, arg);
            }
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateAlertLogContext() throws UtilException {
        this.assertCtxNotNull();
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                UtilNative.terminateAlertLogContext(result);
            }
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    public boolean isUserValid(String userName) throws UtilException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.isUserValid(userName);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTargetHubSize() throws UtilException {
        this.assertCtxNotNull();
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                return UtilNative.getTargetHubSize(result);
            }
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllHASContext(HASContext ctx) throws UtilException {
        Hashtable ht = null;
        ArrayList contexts = new ArrayList();
        try {
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                ht = ctx.getReferenceTable();
                for (Object ref : ht.keySet()) {
                    contexts.add(ref);
                }
                if (contexts.size() > 0) {
                    for (Object ref : contexts) {
                        Trace.out((String)("Releasing ref =" + ref));
                        ht.remove(ref);
                    }
                    ctx.setReferenceTable(ht);
                    ctx.releaseInstance2();
                    Trace.out((String)"Ternminating SRVMContext");
                    SRVMContext sctx = SRVMContext.getInstance();
                    sctx.term();
                }
            }
        }
        catch (SRVMContextException sce) {
            Trace.out((String)sce.getMessage());
            throw new UtilException((Exception)((Object)sce));
        }
        catch (HASContextException hasce) {
            throw new UtilException((Exception)((Object)hasce));
        }
        finally {
            contexts = null;
        }
    }
}

