/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.cluster.common.CommonBaseException;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.trace.Trace;

public class HASException
extends CommonBaseException {
    private Exception m_e;
    private int m_code;
    private String m_debugMsg;

    public HASException(String msg) {
        super(msg);
    }

    public HASException(String msg, Exception e) {
        super(msg);
        this.m_e = e;
    }

    public HASException(Exception e) {
        this.m_e = e;
    }

    public void setDebugMessage(String msg) {
        this.m_debugMsg = msg;
    }

    public String getDebugMessage() {
        return this.m_debugMsg;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public int getCode() {
        return this.m_code;
    }

    private String getHASMessage() {
        String msg = super.getMessage();
        if (Trace.isLevelEnabled((int)16) && this.getDebugMessage() != null) {
            return msg + "(" + this.getDebugMessage() + ":[" + this.m_code + "])";
        }
        if (this.m_code != 0) {
            return msg + " :[" + this.m_code + "]";
        }
        return msg;
    }

    public String getMessage() {
        if (this.m_e == null) {
            return this.getHASMessage();
        }
        return this.getHASMessage() + "\n" + this.m_e.getMessage();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.m_e != null) {
            out.println(NLSMessage.getCausedBy());
            this.m_e.printStackTrace(out);
        }
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.m_e != null) {
            out.println(NLSMessage.getCausedBy());
            this.m_e.printStackTrace(out);
        }
    }
}

