/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import java.util.Hashtable;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.has.AliasNativeResult;
import oracle.ops.mgmt.has.AlreadyExistsException;
import oracle.ops.mgmt.has.CLSREventException;
import oracle.ops.mgmt.has.CLSREventNative;
import oracle.ops.mgmt.has.ClusterAliasException;
import oracle.ops.mgmt.has.ClusterAliasNative;
import oracle.ops.mgmt.has.ClusterAliasNotFoundException;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.ClusterUtilNative;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASContextNative;
import oracle.ops.mgmt.has.HASNativeResult;
import oracle.ops.mgmt.has.InsufficientPrivilegeException;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.has.NetInterfaceNotFoundException;
import oracle.ops.mgmt.has.NodeNotFoundException;
import oracle.ops.mgmt.has.NotFoundException;
import oracle.ops.mgmt.has.UserNotFoundException;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.UtilNative;
import oracle.ops.mgmt.has.VIPException;
import oracle.ops.mgmt.has.VIPNative;
import oracle.ops.mgmt.has.VIPNativeResult;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.has.resource.PrkhMsgID;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class HASContext
implements Constants,
PrkhMsgID {
    public static final int PRSR_INIT_META = 1;
    public static final int PRSR_INIT_LSF = 2;
    public static final int PRSR_INIT_SCLS = 4;
    public static final int PRSR_INIT_SLTS = 8;
    public static final int PRSR_INIT_CLSS = 16;
    public static final int PRSR_INIT_CLSR = 32;
    public static final int PRSR_INIT_CLSCRS = 64;
    public static final int PRSR_INIT_ALL = 127;
    private static boolean s_metaInit = false;
    private static boolean s_lsfInit = false;
    private static boolean s_sclsInit = false;
    private static boolean s_sltsInit = false;
    private static boolean s_clssInit = false;
    private static boolean s_clsrInit = false;
    private static boolean s_clscrsInit = false;
    static Object srvmlibSync = new Object();
    private static HASContext s_ctx;
    private static Object s_instanceLock;
    private static Hashtable s_referenceTable;
    private MessageBundle m_rawMesgBdle = MessageBundle.getMessageBundle((String)"Prkh");

    private HASContext(int moduleInit) throws HASContextException {
        int modInit = moduleInit | 2;
        Trace.out((String)("moduleInit = " + moduleInit));
        this.m_rawMesgBdle.setPackage("oracle.ops.mgmt.has.resource");
        this.loadLibrary();
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
            Trace.out((String)"Initialised SRVMContext");
        }
        catch (SRVMContextException sce) {
            Trace.out((String)sce.getMessage());
            throw new HASContextException(sce.getMessage());
        }
        HASNativeResult result = new HASNativeResult();
        HASContextNative.allocHASContext(modInit, result);
        this.checkResult(result);
    }

    String getNLSMessage(String id) {
        return this.m_rawMesgBdle.getMessage(id, true);
    }

    String getNLSMessage(String id, String[] args) {
        return this.m_rawMesgBdle.getMessage(id, true, (Object[])args);
    }

    int getReferenceCount() {
        if (s_referenceTable == null) {
            return 0;
        }
        return s_referenceTable.size();
    }

    public void setReferenceTable(Hashtable ht) {
        s_referenceTable = ht;
    }

    public Hashtable getReferenceTable() {
        return s_referenceTable;
    }

    public static HASContext getContext() {
        return s_ctx;
    }

    public void checkResult(HASNativeResult result) throws HASContextException {
        if (!result.getStatus()) {
            if (result.getException() == null) {
                throw new HASContextException(this.getNLSMessage("1002"));
            }
            throw new HASContextException(NLSMessage.getInternalErrorMessage(), result.getException());
        }
        if (!result.getNativeResult()) {
            if (result.getException() == null) {
                HASContextException hce = new HASContextException(NLSMessage.getInternalErrorMessage());
                hce.setDebugMessage("HAS Call Failed, no exception found. Result Data " + result.getOSErrCode() + ": " + result.getOSString());
                throw hce;
            }
            throw new HASContextException(NLSMessage.getInternalErrorMessage(), result.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLibrary() throws HASContextException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        Object object = s_instanceLock;
        synchronized (object) {
            try {
                m_system.loadSRVMHASNativeLibrary();
            }
            catch (NativeException ne) {
                throw new HASContextException(this.getNLSMessage("1000"), (Exception)((Object)ne));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HASContext getInstance(int moduleInit, Object ref) throws UnsatisfiedLinkError, HASContextException {
        int localModuleInit = 0;
        Object object = s_instanceLock;
        synchronized (object) {
            if (!s_metaInit) {
                localModuleInit = 1;
            }
            if (!s_lsfInit) {
                localModuleInit |= 2;
            }
            if ((moduleInit & 4) != 0 && !s_sclsInit) {
                localModuleInit |= 4;
            }
            if ((moduleInit & 8) != 0 && !s_sltsInit) {
                localModuleInit |= 8;
            }
            if ((moduleInit & 0x10) != 0 && !s_clssInit) {
                localModuleInit |= 0x10;
            }
            if ((moduleInit & 0x20) != 0 && !s_clsrInit) {
                localModuleInit |= 0x20;
            }
            if ((moduleInit & 0x40) != 0 && !s_clscrsInit) {
                localModuleInit |= 0x40;
            }
            if (s_ctx == null || localModuleInit != 0) {
                if (s_ctx == null) {
                    s_ctx = new HASContext(localModuleInit);
                } else {
                    HASNativeResult result = new HASNativeResult();
                    HASContextNative.allocHASContext(localModuleInit, result);
                }
                if ((localModuleInit & 1) != 0) {
                    s_metaInit = true;
                }
                if ((localModuleInit & 2) != 0) {
                    s_lsfInit = true;
                }
                if ((localModuleInit & 4) != 0) {
                    s_sclsInit = true;
                }
                if ((localModuleInit & 8) != 0) {
                    s_sltsInit = true;
                }
                if ((localModuleInit & 0x10) != 0) {
                    s_clssInit = true;
                }
                if ((localModuleInit & 0x20) != 0) {
                    s_clsrInit = true;
                }
                if ((localModuleInit & 0x40) != 0) {
                    s_clscrsInit = true;
                }
            }
            if (s_referenceTable == null) {
                s_referenceTable = new Hashtable();
            }
            s_referenceTable.put(ref, ref);
        }
        return s_ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseInstance(Object ref) throws HASContextException {
        Object object = s_instanceLock;
        synchronized (object) {
            s_referenceTable.remove(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInstance2() throws HASContextException {
        Object object = s_instanceLock;
        synchronized (object) {
            if (s_referenceTable.size() == 0 && s_ctx != null) {
                try {
                    HASNativeResult result = new HASNativeResult();
                    HASContextNative.freeHASContext(result);
                    s_metaInit = false;
                    s_lsfInit = false;
                    s_sclsInit = false;
                    s_sltsInit = false;
                    s_clssInit = false;
                    s_clsrInit = false;
                    s_clscrsInit = false;
                }
                finally {
                    Trace.out((String)("HAS Context released. Instance: " + s_referenceTable.size()));
                    s_ctx = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClusterAliasSupported() throws HASContextException, ClusterAliasException {
        AliasNativeResult result = new AliasNativeResult();
        boolean supported = false;
        Object object = srvmlibSync;
        synchronized (object) {
            supported = ClusterAliasNative.checkForClusterAliasSupport(result);
        }
        this.checkResult(result);
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createClusterAlias(String clusterAlias, String ip, String netMask) throws HASContextException, ClusterAliasException, AlreadyExistsException {
        AliasNativeResult result = new AliasNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            ClusterAliasNative.createClusterAlias(result, clusterAlias, ip, netMask);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteClusterAlias(String clusterAlias) throws ClusterAliasException, ClusterAliasNotFoundException, HASContextException {
        AliasNativeResult result = new AliasNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            ClusterAliasNative.deleteClusterAlias(result, clusterAlias);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNodeToClusterAlias(String clusterAlias) throws ClusterAliasException, HASContextException, NodeNotFoundException, ClusterAliasNotFoundException, AlreadyExistsException {
        AliasNativeResult result = new AliasNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            ClusterAliasNative.addNodeToClusterAlias(result, clusterAlias);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNodeFromClusterAlias(String clusterAlias) throws HASContextException, ClusterAliasException, NodeNotFoundException {
        AliasNativeResult result = new AliasNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            ClusterAliasNative.removeNodeFromClusterAlias(result, clusterAlias);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getClusterName() throws HASContextException, ClusterUtilException {
        HASNativeResult result = new HASNativeResult();
        String clusterName = null;
        Object object = srvmlibSync;
        synchronized (object) {
            clusterName = ClusterUtilNative.getClusterName(result);
        }
        this.checkResult(result);
        return clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createVIP(String vipName, String ip, String nodeName, String netMask, String[] interfaces) throws HASContextException, VIPException, NodeNotFoundException, AlreadyExistsException {
        VIPNativeResult result = new VIPNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            VIPNative.createVIP(result, vipName, ip, nodeName, netMask, interfaces);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteVIP(String vipName) throws HASContextException, VIPException, VIPNotFoundException {
        VIPNativeResult result = new VIPNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            VIPNative.deleteVIP(result, vipName);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] listInterfaces() throws HASContextException, NetInterfaceNotFoundException, VIPException {
        VIPNativeResult result = new VIPNativeResult();
        String[] interfaces = null;
        Object object = srvmlibSync;
        synchronized (object) {
            interfaces = VIPNative.listNetInterfaces(result);
        }
        this.checkResult(result);
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] listInterfacesEx() throws HASContextException, VIPException {
        VIPNativeResult result = new VIPNativeResult();
        String[] interfaces = null;
        Object object = srvmlibSync;
        synchronized (object) {
            interfaces = VIPNative.listNetInterfacesEx(result);
        }
        this.checkResult(result);
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNetMask(String netIF) throws HASContextException, VIPException {
        VIPNativeResult result = new VIPNativeResult();
        String netmask = null;
        Object object = srvmlibSync;
        synchronized (object) {
            netmask = VIPNative.getNetMask(result, netIF);
        }
        this.checkResult(result);
        return netmask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOracleUser(String oraHome, String oraSID) throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        String user = null;
        Object object = srvmlibSync;
        synchronized (object) {
            user = UtilNative.getOracleUser(result, oraHome, oraSID);
        }
        this.checkResult(result);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCurrentUser() throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        String user = null;
        Object object = srvmlibSync;
        synchronized (object) {
            user = UtilNative.getCurrentUser(result);
        }
        this.checkResult(result);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCurrentUserPrimaryGroup() throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        String user = null;
        Object object = srvmlibSync;
        synchronized (object) {
            user = UtilNative.getCurrentUserPrimaryGroup(result);
        }
        this.checkResult(result);
        return user;
    }

    String getPrimaryGroup(String userName) throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        String user = UtilNative.getPrimaryGroup(result, userName);
        this.checkResult(result);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isGroupMember(String userName, String groupName) throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        boolean isMbr = false;
        Object object = srvmlibSync;
        synchronized (object) {
            isMbr = UtilNative.isGroupMember(result, userName, groupName);
        }
        this.checkResult(result);
        return isMbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasHAPrivilege() throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        boolean hasPrivs = false;
        Object object = srvmlibSync;
        synchronized (object) {
            hasPrivs = UtilNative.hasHAPrivilege(result);
        }
        this.checkResult(result);
        return hasPrivs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void becomeOracleUser(String oraHome, String oraSID) throws HASContextException, InsufficientPrivilegeException, UserNotFoundException, IllegalArgumentException {
        HASNativeResult result = new HASNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            UtilNative.becomeOracleUser(result, oraHome, oraSID);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void becomeHAPrivilegedUser() throws HASContextException, InsufficientPrivilegeException {
        HASNativeResult result = new HASNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            UtilNative.becomeHAPrivilegedUser(result);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCRSHome() throws HASContextException, UtilException, NotFoundException {
        HASNativeResult result = new HASNativeResult();
        String home = null;
        Object object = srvmlibSync;
        synchronized (object) {
            home = UtilNative.getCRSHome(result);
        }
        Trace.out((String)home);
        this.checkResult(result);
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForNodeDownEvent() throws HASContextException, CLSREventException {
        HASNativeResult result = new HASNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            CLSREventNative.waitForNodeDownEvent(result);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postNodeDownEvent() throws HASContextException, CLSREventException {
        HASNativeResult result = new HASNativeResult();
        Object object = srvmlibSync;
        synchronized (object) {
            CLSREventNative.postNodeDownEvent(result);
        }
        this.checkResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUserValid(String userName) throws HASContextException, UtilException {
        HASNativeResult result = new HASNativeResult();
        boolean isUsr = false;
        Object object = srvmlibSync;
        synchronized (object) {
            isUsr = UtilNative.isUserValid(result, userName);
        }
        this.checkResult(result);
        return isUsr;
    }

    static {
        s_instanceLock = new Object();
    }
}

