/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.GroupMembershipException;
import oracle.ops.mgmt.has.GroupMembershipNative;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASNativeResult;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.trace.Trace;

public class GroupMembership {
    private HASContext m_ctx = null;
    private String m_clusterName = null;
    private Object m_ref = new Object();
    private static final String OCR_PREFIX = "ocr_";

    public GroupMembership() throws GroupMembershipException {
        int moduleInit = 24;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException hce) {
            Trace.out((String)("GroupMembership Instance Allocation Failed: " + (Object)((Object)hce)));
            throw new GroupMembershipException(NLSMessage.getHASInitFailed(), (Exception)((Object)hce));
        }
        Trace.out((String)"GroupMembership Instance created.");
        Trace.out((String)"GroupMembership: Attempt to get cluster name.");
        if (this.m_ctx != null) {
            try {
                this.m_clusterName = this.m_ctx.getClusterName();
            }
            catch (HASContextException hce) {
                Trace.out((String)("GroupMembership Clustername Retrieval Failed: " + (Object)((Object)hce)));
                throw new GroupMembershipException("GroupMembership: problem in retrieving cluster name\n" + hce.getMessage());
            }
            catch (ClusterUtilException cae) {
                Trace.out((String)("GroupMembership Clustername Retrieval Failed: " + (Object)((Object)cae)));
                throw new GroupMembershipException("GroupMembership: problem in retrieving cluster name\n" + cae.getMessage());
            }
            Trace.out((String)("Cluster Name is:" + this.m_clusterName));
        }
    }

    public void destroy() throws GroupMembershipException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new GroupMembershipException(NLSMessage.getInternalErrorMessage() + ": " + t);
        }
    }

    protected void finalize() throws Throwable {
        Trace.out((String)("GroupMembership: finalized called for " + this));
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkGroup(String groupName) throws GroupMembershipException {
        boolean isGroupExists = false;
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                isGroupExists = GroupMembershipNative.checkGroup(result, groupName);
            }
            Trace.out((String)("checkGroup returned nr=" + result.getNativeResult() + " status=" + result.getStatus()));
            this.m_ctx.checkResult(result);
            return isGroupExists;
        }
        catch (HASContextException hce) {
            throw new GroupMembershipException(NLSMessage.getInternalErrorMessage(), (Exception)((Object)hce));
        }
    }

    public boolean checkOCRgroup() {
        boolean isOCRgroup = false;
        String OCRgroupName = OCR_PREFIX + this.m_clusterName;
        try {
            isOCRgroup = this.checkGroup(OCRgroupName);
            return isOCRgroup;
        }
        catch (GroupMembershipException gme) {
            return false;
        }
    }
}

