/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import oracle.cluster.asm.ASMMode;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.NodeRole;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.ClusterUtilNative;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASNativeResult;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.has.resource.PrkhMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class ClusterUtil
implements PrkhMsgID {
    private HASContext m_ctx;
    private boolean m_bSKGXN;
    private Object m_ref = new Object();

    public ClusterUtil() throws ClusterUtilException {
        int moduleInit = 16;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException hce) {
            throw new ClusterUtilException(NLSMessage.getHASInitFailed(), (Exception)((Object)hce));
        }
        Trace.out((String)"ClusterUtil Instance created");
        this.m_bSKGXN = !Boolean.getBoolean("srvm.daemon.use_css");
        Trace.out((String)("ClusterUtil m_bSKGXN=" + this.m_bSKGXN));
    }

    public void destroy() throws ClusterUtilException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new ClusterUtilException(NLSMessage.getInternalErrorMessage() + ": " + t);
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.getTraceFile() != null) {
            Trace.out((String)("ClusterUtil: finalized called for " + this));
        }
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    private void handleUnexpectedException(HASContextException hce) throws ClusterUtilException {
        throw new ClusterUtilException(NLSMessage.getInternalErrorMessage(), (Exception)((Object)hce));
    }

    private void handleHASContextException(HASContextException e, String errMsgFromCaller) throws ClusterUtilException {
        String cssErrCode = "";
        String strErrCode = "";
        switch (e.getCode()) {
            case 2: {
                cssErrCode = "1051";
                break;
            }
            case 3: {
                cssErrCode = "1054";
                break;
            }
            case 6: {
                cssErrCode = "1058";
                break;
            }
            case 11: {
                cssErrCode = "1053";
                break;
            }
            case 13: {
                cssErrCode = "1050";
                break;
            }
            case 16: {
                cssErrCode = "1052";
                break;
            }
            case 21: {
                cssErrCode = "1055";
                break;
            }
            default: {
                cssErrCode = "1056";
                strErrCode = "(error code[" + Integer.toString(e.getCode()) + "])";
            }
        }
        MessageBundle messageBundle = MessageBundle.getMessageBundle((String)"Prkh");
        String cssErrMsg = "";
        cssErrMsg = messageBundle.getMessage(cssErrCode, true) + strErrCode;
        cssErrMsg = errMsgFromCaller + System.getProperty("line.separator") + cssErrMsg;
        throw new ClusterUtilException(cssErrMsg, (Exception)((Object)e));
    }

    public String getClusterName() throws ClusterUtilException {
        try {
            return this.m_ctx.getClusterName();
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterGUID() throws ClusterUtilException {
        String clusterGUID = null;
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                clusterGUID = ClusterUtilNative.getClusterGUID(result);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
        return clusterGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateClusterGUID() throws ClusterUtilException {
        String clusterGUID = null;
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                clusterGUID = ClusterUtilNative.generateClusterGUID(result);
            }
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
        return clusterGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID(String resourceName, String resourceType) throws ClusterUtilException {
        String clientid = null;
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                clientid = ClusterUtilNative.getClientID(result, this.getClusterName(), resourceName, resourceType);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
        return clientid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DHCPReleaseLease(String clientid) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                ClusterUtilNative.DHCPReleaseLease(result, clientid);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalNodeName() throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            String localNode = null;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                localNode = ClusterUtilNative.getLocalNodeName(result);
            }
            this.m_ctx.checkResult(result);
            return localNode;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    public String[] getNodeNames(NodeRole role) throws ClusterUtilException {
        return this.getActiveNodesHelper(role.getRole(), false);
    }

    public String[] getNodeNames() throws ClusterUtilException {
        return this.getNodeNames(NodeRole.NONE);
    }

    public String[] getRIMNodes() throws ClusterUtilException {
        return this.getNodeNames(NodeRole.RIM);
    }

    public String[] getHUBNodes() throws ClusterUtilException {
        return this.getNodeNames(NodeRole.HUB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getActiveNodesHelper(int flag, boolean isActive) throws ClusterUtilException {
        int enumCount = NodeRole.values().length;
        try {
            HASNativeResult result = new HASNativeResult();
            String[] nodes = null;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                nodes = ClusterUtilNative.getNodeNames(result, flag, isActive);
            }
            this.m_ctx.checkResult(result);
            return nodes;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    public String[] getActiveNodes() throws ClusterUtilException {
        return this.getActiveNodesHelper(NodeRole.NONE.getRole(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostName(String nodeName) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            String hostName = null;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                hostName = ClusterUtilNative.getHostName(result, nodeName);
            }
            this.m_ctx.checkResult(result);
            return hostName;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRole getNodeActiveRole() throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            int role = 0;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                role = ClusterUtilNative.getNodeActiveRole(result);
                Trace.out((String)("Get NodeActiveRole " + role));
            }
            this.m_ctx.checkResult(result);
            return NodeRole.getEnumMember((int)role);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return NodeRole.NONE;
        }
        catch (EnumConstantNotPresentException ecnpe) {
            return NodeRole.NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRole getNodeConfiguredRole(String nodeName) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            int role = 0;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                role = ClusterUtilNative.getNodeConfiguredRole(result, nodeName);
                Trace.out((String)("NodeConfiguredRole is " + role));
            }
            this.m_ctx.checkResult(result);
            return NodeRole.getEnumMember((int)role);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return NodeRole.NONE;
        }
        catch (EnumConstantNotPresentException ecnpe) {
            return NodeRole.NONE;
        }
    }

    public boolean checkClustDb(String groupName) throws ClusterUtilException {
        return this.checkClustDb(groupName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkClustDb(String groupName, boolean bskgxn) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            boolean alive = false;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                alive = ClusterUtilNative.checkClustDb(result, groupName, bskgxn);
            }
            Trace.out((String)("Returned back from native code in ClusterUtil alive=" + alive));
            return alive;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    public boolean checkInstance(String groupName, String instanceName) throws ClusterUtilException {
        return this.checkInstance(groupName, instanceName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInstance(String groupName, String instanceName, boolean bskgxn) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            boolean alive = false;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                alive = ClusterUtilNative.checkInstance(result, groupName, instanceName, bskgxn);
            }
            Trace.out((String)("alive = " + alive));
            this.m_ctx.checkResult(result);
            return alive;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInstanceNumber(String dbUniqueName, String instanceName) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            String dbGrpName = "DB" + dbUniqueName.toUpperCase();
            int instNum = -1;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                instNum = ClusterUtilNative.getInstanceNumber(result, dbGrpName, instanceName.toLowerCase());
            }
            Trace.out((String)("instNum = " + instNum));
            this.m_ctx.checkResult(result);
            return instNum;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGSDPortNum(String groupName, String nodeName) throws ClusterUtilException {
        Trace.out((String)(" groupname = " + groupName + " nodename-" + nodeName));
        try {
            HASNativeResult result = new HASNativeResult();
            int port = -1;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                port = ClusterUtilNative.getGSDPortNum(result, groupName, nodeName, this.m_bSKGXN);
            }
            this.m_ctx.checkResult(result);
            return port;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLiveDaemons(String groupName) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            String[] liveNodes = null;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                liveNodes = ClusterUtilNative.getLiveDaemons(result, groupName, this.m_bSKGXN);
            }
            Trace.out((String)"Out of getLiveDaemons");
            this.m_ctx.checkResult(result);
            if (liveNodes.length == 0) {
                Trace.out((String)"Returning null");
                return null;
            }
            Trace.out((String)("No of LiveDaemons " + liveNodes.length));
            Trace.out((String)("Result " + result.getStatus()));
            return liveNodes;
        }
        catch (HASContextException hasce) {
            Trace.out((String)"Exception in getting LiveDaemons");
            Trace.out((Exception)((Object)hasce));
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regInGroup(String groupName, int portNum) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                ClusterUtilNative.regInGroup(result, groupName, portNum, this.m_bSKGXN);
            }
            this.m_ctx.checkResult(result);
            return;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return;
        }
    }

    public void pollCSSGroup(String groupName) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            ClusterUtilNative.pollCSSGroup(result, groupName);
            this.m_ctx.checkResult(result);
            return;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] get9iDaemons(String groupName) throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            Trace.out((String)"Inside ClusterUtil.get9iDaemons");
            String[] daemons = null;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                daemons = ClusterUtilNative.get9iDaemons(result, groupName);
            }
            Trace.out((String)"Returned from native code");
            this.m_ctx.checkResult(result);
            return daemons;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSMode getCSSMode() throws ClusterUtilException {
        try {
            HASNativeResult result = new HASNativeResult();
            Trace.out((String)"Returned from native code");
            int mod = 0;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                mod = ClusterUtilNative.getCSSMode(result);
            }
            Trace.out((String)"Returned from native code");
            this.m_ctx.checkResult(result);
            return CSSMode.getEnumMember((int)mod);
        }
        catch (HASContextException hasce) {
            String errMsg = this.m_ctx.getNLSMessage("1016");
            this.handleHASContextException(hasce, errMsg);
            return CSSMode.cssNULL;
        }
        catch (EnumConstantNotPresentException ecnpe) {
            return CSSMode.cssNULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNodeNum0Exists() throws ClusterUtilException {
        boolean n0exists = false;
        try {
            HASNativeResult result = new HASNativeResult();
            Trace.out((String)"Calling native code isNodeNum0Exists");
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                n0exists = ClusterUtilNative.isNodeNum0Exists(result);
            }
            Trace.out((String)"Returned from native code");
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            String errMsg = this.m_ctx.getNLSMessage("1057");
            this.handleHASContextException(hasce, errMsg);
        }
        return n0exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASMMode getASMMode() throws ClusterUtilException {
        String modestr = null;
        try {
            HASNativeResult result = new HASNativeResult();
            Trace.out((String)"Calling native code getASMMode");
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                modestr = ClusterUtilNative.getASMMode(result);
            }
            Trace.out((String)"Returned from native code");
            Trace.out((String)("mode string returned from native code is " + modestr));
            this.m_ctx.checkResult(result);
            return ASMMode.getEnumMember((String)modestr);
        }
        catch (HASContextException hasce) {
            String errMsg = this.m_ctx.getNLSMessage("1059");
            this.handleHASContextException(hasce, errMsg);
            return ASMMode.NONE;
        }
        catch (EnumConstNotFoundException ecnpe) {
            throw new ClusterUtilException((Exception)((Object)ecnpe));
        }
    }
}

