/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.has.ClusterLockNative;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASNativeResult;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.trace.Trace;

public class ClusterLock {
    private HASContext m_ctx;
    private Object m_ref = new Object();

    public ClusterLock() throws ClusterLockException {
        int moduleInit = 24;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException hce) {
            Trace.out((String)("ClusterLock Instance Allocation Failed: " + (Object)((Object)hce)));
            throw new ClusterLockException(NLSMessage.getHASInitFailed(), (Exception)((Object)hce));
        }
        Trace.out((String)"ClusterLock Instance created.");
    }

    public void destroy() throws ClusterLockException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new ClusterLockException(NLSMessage.getInternalErrorMessage() + ": " + t);
        }
    }

    protected void finalize() throws Throwable {
        Trace.out((String)("ClusterLock: finalized called for " + this));
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    private void handleUnexpectedException(HASContextException hce) throws ClusterLockException {
        throw new ClusterLockException(NLSMessage.getInternalErrorMessage(), (Exception)((Object)hce));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(String lockName) throws ClusterLockException {
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                ClusterLockNative.acquire(result, lockName);
            }
            Trace.out((String)("Acquire returned nr=" + result.getNativeResult() + " status=" + result.getStatus()));
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireNoWait(String lockName) throws ClusterLockException {
        try {
            HASNativeResult result = new HASNativeResult();
            boolean got = false;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                got = ClusterLockNative.acquireNoWait(result, lockName);
            }
            this.m_ctx.checkResult(result);
            return got;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared(String lockName) throws ClusterLockException {
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                ClusterLockNative.acquireShared(result, lockName);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireNoWaitShared(String lockName) throws ClusterLockException {
        try {
            HASNativeResult result = new HASNativeResult();
            boolean got = false;
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                got = ClusterLockNative.acquireNoWaitShared(result, lockName);
            }
            this.m_ctx.checkResult(result);
            return got;
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String lockName) throws ClusterLockException {
        try {
            HASNativeResult result = new HASNativeResult();
            Object object = HASContext.srvmlibSync;
            synchronized (object) {
                ClusterLockNative.release(result, lockName);
            }
            this.m_ctx.checkResult(result);
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
        }
    }
}

