/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import java.util.Enumeration;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.RemoteCommand;
import oracle.ops.mgmt.has.AlreadyExistsException;
import oracle.ops.mgmt.has.ClusterAliasException;
import oracle.ops.mgmt.has.ClusterAliasJoinOperation;
import oracle.ops.mgmt.has.ClusterAliasLeaveOperation;
import oracle.ops.mgmt.has.ClusterAliasNotFoundException;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.HASDebug;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.has.NodeNotFoundException;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class ClusterAlias {
    private HASContext m_ctx;
    private Boolean m_supported;
    private Object m_ref = new Object();

    public ClusterAlias() throws ClusterAliasException {
        int moduleInit = 56;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException hce) {
            Trace.out((String)("ClusterAlias Instance Allocation Failed: " + (Object)((Object)hce)));
            throw new ClusterAliasException(NLSMessage.getHASInitFailed(), (Exception)((Object)hce));
        }
        Trace.out((String)"ClusterAlias Instance created.");
    }

    public void destroy() throws ClusterAliasException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new ClusterAliasException(NLSMessage.getInternalErrorMessage() + ":" + t.toString());
        }
    }

    protected void finalize() throws Throwable {
        Trace.out((String)("ClusterAlias: finalized called for " + this));
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    private void handleUnexpectedException(HASContextException hce) throws ClusterAliasException {
        throw new ClusterAliasException(hce.getMessage(), (Exception)((Object)hce));
    }

    private void handleRemoteOpException(String msg, Exception e) throws ClusterAliasException, ClusterAliasNotFoundException {
        if (e instanceof ClusterAliasNotFoundException) {
            throw new ClusterAliasNotFoundException(msg, e);
        }
        throw new ClusterAliasException(msg, e);
    }

    private void checkNode(String nodeName) throws NodeNotFoundException, ClusterAliasException {
        String[] nodeList = new String[]{nodeName};
        this.checkNode(nodeList);
    }

    private void checkNode(String[] nodeList) throws NodeNotFoundException, ClusterAliasException {
        String[] activeList = null;
        GetActiveNodes nodeMgr = null;
        try {
            nodeMgr = GetActiveNodes.create();
            activeList = nodeMgr.getNodeList();
        }
        catch (ClusterException ce) {
            throw new ClusterAliasException((Exception)((Object)ce));
        }
        Vector<String> v = new Vector<String>(nodeList.length);
        for (int i = 0; i < nodeList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < activeList.length; ++j) {
                if (!nodeList[i].equals(activeList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            v.addElement(nodeList[i]);
        }
        if (v.size() > 0) {
            String[] notFound = new String[v.size()];
            int i = 0;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                notFound[i++] = (String)e.nextElement();
            }
            throw new NodeNotFoundException(notFound);
        }
    }

    private RemoteCommand[] createJoinCommands(String alias, String[] nodeList) throws ClusterAliasException {
        RemoteCommand[] remoteCommands = new RemoteCommand[nodeList.length];
        int i = 0;
        try {
            for (i = 0; i < nodeList.length; ++i) {
                ClusterAliasJoinOperation joinOp = new ClusterAliasJoinOperation(alias);
                remoteCommands[i] = new RemoteCommand(nodeList[i], (Operation)joinOp);
            }
        }
        catch (ClusterException ce) {
            String[] args = new String[]{alias};
            throw new ClusterAliasException(this.m_ctx.getNLSMessage("1004", args) + " " + nodeList[i]);
        }
        return remoteCommands;
    }

    private RemoteCommand[] createLeaveCommands(String alias, String[] nodeList) throws ClusterAliasException {
        RemoteCommand[] remoteCommands = new RemoteCommand[nodeList.length];
        int i = 0;
        try {
            for (i = 0; i < nodeList.length; ++i) {
                ClusterAliasLeaveOperation joinOp = new ClusterAliasLeaveOperation(alias);
                remoteCommands[i] = new RemoteCommand(nodeList[i], (Operation)joinOp);
            }
        }
        catch (ClusterException ce) {
            String[] args = new String[]{alias};
            throw new ClusterAliasException(this.m_ctx.getNLSMessage("1005", args) + " " + nodeList[i]);
        }
        return remoteCommands;
    }

    private void processRemoteOperationResult(String alias, RemoteCommand[] cmds, boolean join) throws ClusterAliasException, ClusterAliasNotFoundException, NodeNotFoundException {
        StringBuffer sb = new StringBuffer();
        Throwable resultException = null;
        boolean status = true;
        for (int i = 0; i < cmds.length; ++i) {
            try {
                OperationResult result = cmds[i].getOperationResult();
                if (result.getStatus() == 0) continue;
                status = false;
                resultException = result.getException();
                sb.append(" " + cmds[i].getNode());
                continue;
            }
            catch (ClusterException ce) {
                Trace.out((String)("Failed to get remote operation result for node: " + cmds[i].getNode()));
                Trace.out((Exception)((Object)ce));
                resultException = ce;
                sb.append(" " + cmds[i].getNode());
                status = false;
            }
        }
        if (!status) {
            String msg;
            String[] args = new String[]{alias};
            String string = msg = join ? this.m_ctx.getNLSMessage("1004", args) + sb.toString() + "\n" : this.m_ctx.getNLSMessage("1005", args) + sb.toString() + "\n";
            if (resultException == null) {
                throw new ClusterAliasException(msg);
            }
            this.handleRemoteOpException(msg, (Exception)resultException);
        }
    }

    private void assertCtxNotNull() throws ClusterAliasException {
        HASDebug.assertFunc(this, this.m_ctx != null, "ClusterAlias: ctx is null");
    }

    public synchronized boolean isSupported() throws ClusterAliasException {
        HASDebug.assertFunc(this, this.m_ctx != null, "ClusterAlias: ctx is null");
        if (this.m_supported == null) {
            try {
                this.m_supported = new Boolean(this.m_ctx.isClusterAliasSupported());
            }
            catch (HASContextException hce) {
                this.handleUnexpectedException(hce);
            }
        }
        return this.m_supported;
    }

    public void create(String alias, String ip, String netMask) throws ClusterAliasException, IllegalArgumentException, AlreadyExistsException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        HASDebug.assertStringArgument(ip, "IP Address");
        HASDebug.assertStringArgument(netMask, "NetMask");
        this.assertCtxNotNull();
        try {
            this.m_ctx.createClusterAlias(alias, ip, netMask);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
        }
    }

    public void delete(String alias) throws ClusterAliasException, ClusterAliasNotFoundException, IllegalArgumentException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        this.assertCtxNotNull();
        try {
            this.m_ctx.deleteClusterAlias(alias);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
        }
    }

    public void addNode(String alias) throws ClusterAliasException, IllegalArgumentException, NodeNotFoundException, ClusterAliasNotFoundException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        this.assertCtxNotNull();
        try {
            this.m_ctx.addNodeToClusterAlias(alias);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    public void addNode(String alias, String nodeName) throws ClusterAliasException, IllegalArgumentException, NodeNotFoundException, ClusterAliasNotFoundException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        HASDebug.assertStringArgument(nodeName, "NodeName");
        this.assertCtxNotNull();
        try {
            if (nodeName.equals(Cluster.getLocalNode())) {
                this.addNode(alias);
            } else {
                String[] nodeList = new String[]{nodeName};
                this.addNode(alias, nodeList);
            }
        }
        catch (ClusterException ce) {
            throw new ClusterAliasException((Exception)((Object)ce));
        }
    }

    public void addNode(String alias, String[] nodeList) throws ClusterAliasException, IllegalArgumentException, NodeNotFoundException, ClusterAliasNotFoundException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        if (nodeList.length <= 0) {
            throw new IllegalArgumentException("Node list has no members.");
        }
        RemoteCommand[] cmds = this.createJoinCommands(alias, nodeList);
        try {
            new ClusterCmd().submit((Command[])cmds);
        }
        catch (ClusterException ce) {
            Trace.out((String)("Could not submit join cluster alias commands:" + ce.getMessage()));
        }
        this.processRemoteOperationResult(alias, cmds, true);
    }

    public void removeNode(String alias) throws ClusterAliasException, ClusterAliasNotFoundException, IllegalArgumentException, NodeNotFoundException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        this.assertCtxNotNull();
        try {
            this.m_ctx.removeNodeFromClusterAlias(alias);
        }
        catch (HASContextException hce) {
            this.handleUnexpectedException(hce);
        }
    }

    public void removeNode(String alias, String nodeName) throws ClusterAliasException, NodeNotFoundException, IllegalArgumentException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        HASDebug.assertStringArgument(nodeName, "NodeName");
        this.assertCtxNotNull();
        try {
            if (nodeName.equals(Cluster.getLocalNode())) {
                this.removeNode(alias);
            } else {
                String[] nodeList = new String[]{nodeName};
                this.removeNode(alias, nodeList);
            }
        }
        catch (ClusterException ce) {
            throw new ClusterAliasException((Exception)((Object)ce));
        }
    }

    public void removeNode(String alias, String[] nodeList) throws ClusterAliasException, IllegalArgumentException, NodeNotFoundException, ClusterAliasNotFoundException {
        HASDebug.assertStringArgument(alias, "ClusterAlias");
        if (nodeList.length <= 0) {
            throw new IllegalArgumentException("Node list has no members.");
        }
        RemoteCommand[] cmds = this.createLeaveCommands(alias, nodeList);
        try {
            new ClusterCmd().submit((Command[])cmds);
        }
        catch (ClusterException ce) {
            Trace.out((String)("Could not submit leave cluster alias commands:" + ce.getMessage()));
        }
        this.processRemoteOperationResult(alias, cmds, false);
    }

    public String getClusterName() throws UtilException, ClusterAliasException {
        this.assertCtxNotNull();
        try {
            return this.m_ctx.getClusterName();
        }
        catch (HASContextException hasce) {
            this.handleUnexpectedException(hasce);
            return null;
        }
        catch (ClusterUtilException hasce) {
            throw new ClusterAliasException((Exception)((Object)hasce));
        }
    }
}

