/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.has;

import oracle.ops.mgmt.has.CLSREventException;
import oracle.ops.mgmt.has.HASContext;
import oracle.ops.mgmt.has.HASContextException;
import oracle.ops.mgmt.has.NLSMessage;
import oracle.ops.mgmt.trace.Trace;

public class CLSREvent {
    private HASContext m_ctx;
    private Object m_ref = new Object();

    public CLSREvent() throws CLSREventException {
        int moduleInit = 32;
        try {
            this.m_ctx = HASContext.getInstance(moduleInit, this.m_ref);
        }
        catch (HASContextException he) {
            throw new CLSREventException(NLSMessage.getHASInitFailed(), (Exception)((Object)he));
        }
        Trace.out((String)"\n CLSREvent Instance Created");
    }

    protected void destroy() throws CLSREventException {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new CLSREventException(t.toString());
        }
    }

    private void handleUnexpectedException(HASContextException hce) throws CLSREventException {
        throw new CLSREventException(hce.getMessage(), (Exception)((Object)hce));
    }

    protected void finalize() throws Throwable {
        Trace.out((String)("Util: finalized called for " + this));
        if (this.m_ctx != null) {
            this.m_ctx.releaseInstance(this.m_ref);
        }
        this.m_ctx = null;
    }

    public void waitForNodeDownEvent() throws CLSREventException {
        try {
            this.m_ctx.waitForNodeDownEvent();
        }
        catch (HASContextException he) {
            this.handleUnexpectedException(he);
        }
    }

    public void postNodeDownEvent() throws CLSREventException {
        try {
            this.m_ctx.postNodeDownEvent();
        }
        catch (HASContextException he) {
            this.handleUnexpectedException(he);
        }
    }
}

