/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.type.TaskSet;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TasksXMLReader {
    private static TasksXMLReader instance;
    private static Vector<TaskSet> tasks;

    private TasksXMLReader() {
        TasksXMLReader.setup();
    }

    public static TasksXMLReader getInstance() {
        if (instance == null) {
            instance = new TasksXMLReader();
        }
        return instance;
    }

    private static void setup() {
        tasks = new Vector();
        TasksXMLReader.processXML();
    }

    public static void processXML() {
        Properties.getInstance();
        File file = new File(Properties.taskSetsXml);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("task");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Object object;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                String string2 = namedNodeMap.getNamedItem("id").getNodeValue();
                String string3 = namedNodeMap.getNamedItem("type").getNodeValue();
                TaskSet taskSet = new TaskSet(string2, string3);
                ArrayList<String> arrayList = new ArrayList<String>();
                Element element = (Element)((Element)nodeList.item(i)).getElementsByTagName("component").item(0);
                if (element != null) {
                    object = element.getChildNodes().item(0).getNodeValue();
                    if (((String)object).contains(",")) {
                        for (Object object2 : string = ((String)object).split(",")) {
                            arrayList.add((String)object2);
                        }
                    } else {
                        arrayList.add(((String)object).trim());
                    }
                    taskSet.setComponents(arrayList);
                }
                object = new ArrayList();
                string = (Element)((Element)nodeList.item(i)).getElementsByTagName("command").item(0);
                if (string != null) {
                    String string4 = string.getChildNodes().item(0).getNodeValue();
                    if (string4.contains(",")) {
                        String[] stringArray;
                        for (String string5 : stringArray = string4.split(",")) {
                            object.add(string5);
                        }
                    } else {
                        object.add(string4.trim());
                    }
                    taskSet.setCommands((List<String>)object);
                }
                tasks.add(taskSet);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            StringBuilder stringBuilder = new StringBuilder().append("Exception in parsing ");
            Properties.getInstance();
            Output.print(stringBuilder.append(Properties.taskSetsXml).toString());
        }
        catch (SAXException sAXException) {
            StringBuilder stringBuilder = new StringBuilder().append("SAXException in ");
            Properties.getInstance();
            Output.print(stringBuilder.append(Properties.taskSetsXml).toString());
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder().append("IOException in reading ");
            Properties.getInstance();
            Output.print(stringBuilder.append(Properties.taskSetsXml).toString());
        }
    }

    public static void listTaskSets(Vector<TaskSet> vector) {
        for (TaskSet taskSet : vector) {
            Output.print("-------------------------------------");
            Output.print("Id : " + taskSet.getId());
            Output.print("Description : " + taskSet.getType());
            Output.print("Task commands : " + taskSet.getCommands());
            Output.print("Task components : " + taskSet.getComponents());
            Output.print("-------------------------------------");
        }
    }

    private static List<String> extractVariables(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%' && bl) {
                bl = false;
                arrayList.add(string2.replace("%", ""));
                string2 = "";
            } else if (cArray[i] == '%' && !bl) {
                bl = true;
            }
            if (!bl) continue;
            string2 = string2 + cArray[i];
        }
        return arrayList;
    }

    private static String replaceVariables(String string) {
        List<String> list = TasksXMLReader.extractVariables(string);
        for (String string2 : list) {
            Output.print("var : " + string2);
            if (!string2.equalsIgnoreCase("tfa_home")) continue;
            Properties.getInstance();
            string = string.replaceAll("%tfa_home%", Properties.tfaHome);
        }
        return string;
    }

    private static void collectComponents(List<String> list) {
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = Calendar.getInstance().getTime();
        String string2 = simpleDateFormat.format(date) + ".zip";
        string2 = string2.replaceAll("-", "_");
        String string3 = "collection_" + simpleDateFormat.format(date).replaceAll("-", "_") + "_node_all";
        String string4 = " -z " + string2 + " -node local" + " -tag " + string3;
        for (String string5 : list) {
            if (string5.equalsIgnoreCase("RDBMS")) {
                string4 = string4 + " -database all";
                continue;
            }
            if (string5.equalsIgnoreCase("ASM")) {
                string4 = string4 + " -asm";
                continue;
            }
            if (string5.equalsIgnoreCase("CRS")) {
                string4 = string4 + " -crs";
                continue;
            }
            if (string5.equalsIgnoreCase("INSTALL")) {
                string4 = string4 + " -install";
                continue;
            }
            if (string5.equalsIgnoreCase("OS")) {
                string4 = string4 + " -os";
                continue;
            }
            if (!string5.equalsIgnoreCase("ALL")) continue;
            string4 = string4 + " -all";
        }
        Output.print("Args for diag collect : " + string4);
        Action action = new Action("ziptracesfordates", string, "TFAScanning", string4);
        action.store();
    }

    public static void runTasks(List<String> list, PrintWriter printWriter) {
        for (String string : list) {
            for (TaskSet taskSet : tasks) {
                if (!taskSet.getId().equals(string)) continue;
                printWriter.println("Executing task with id = " + taskSet.getId());
                printWriter.println("Task type = " + taskSet.getType());
                if (taskSet.getType().equals("collect")) {
                    printWriter.println("The following components will be collected : " + taskSet.getComponents());
                    TasksXMLReader.collectComponents(taskSet.getComponents());
                    continue;
                }
                if (!taskSet.getType().equals("execute")) continue;
                printWriter.println("The following commands will be executed : ");
                for (String string2 : taskSet.getCommands()) {
                    string2 = TasksXMLReader.replaceVariables(string2);
                    printWriter.println(string2);
                }
            }
        }
    }

    public static List<String> getTasksForID(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TaskSet taskSet : tasks) {
            if (!taskSet.getId().equals(string)) continue;
            String string2 = taskSet.getType();
            if (string2.equalsIgnoreCase("collect")) {
                arrayList.addAll(taskSet.getComponents());
                continue;
            }
            if (!string2.equalsIgnoreCase("execute")) continue;
            arrayList.addAll(taskSet.getCommands());
        }
        return arrayList;
    }
}

