/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.xml.DumpXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimileJSON {
    Map<String, String> fileToInstanceMap;
    private Map<String, Map<String, String>> allEvents;
    String jsonFileName;
    Map<String, Integer> instanceToTrackMap;
    String pattern = "MMM dd HH:mm:ss yyyy";
    SimpleDateFormat dateFormat = new SimpleDateFormat(this.pattern);

    public SimileJSON() {
        this.init();
    }

    private void init() {
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.jsonFileName = stringBuilder.append(Properties.inventoryDir).append(File.separator).append("simile_events.js").toString();
        this.fileToInstanceMap = new HashMap<String, String>();
        this.instanceToTrackMap = new HashMap<String, Integer>();
        this.allEvents = new HashMap<String, Map<String, String>>();
        this.getTracks();
        System.out.println("Dumping instance data from BDb into " + this.jsonFileName);
        DumpXml.DumpSimileData(this.jsonFileName, this.fileToInstanceMap, this.instanceToTrackMap);
        this.processMergedFilesDB();
        this.processMergedFilesASM();
        this.createJSONFromXML();
    }

    private void getTracks() {
        int n = 1;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            File file = new File(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("DBALERTS_MERGED").append(File.separator).append("files_qscan_out.xml").toString());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("QSCAN");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                NodeList nodeList2 = ((Element)node).getElementsByTagName("FILE");
                NodeList nodeList3 = ((Element)node).getElementsByTagName("INSTANCE");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string = nodeList2.item(j).getChildNodes().item(0).getNodeValue();
                    String string2 = null;
                    if (nodeList3.item(j).getChildNodes().item(0) != null) {
                        string2 = nodeList3.item(j).getChildNodes().item(0).getNodeValue();
                    }
                    if (!this.instanceToTrackMap.containsKey(string2)) {
                        this.instanceToTrackMap.put(string2, ++n);
                    }
                    this.fileToInstanceMap.put(string, string2);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("File not found : ");
            Properties.getInstance();
            System.out.println(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("DBALERTS_MERGED").append(File.separator).append("files_qscan_out.xml").toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getTracksForASM(n);
    }

    private void getTracksForASM(int n) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            File file = new File(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("ASMALERTS_MERGED").append(File.separator).append("files_qscan_out.xml").toString());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("QSCAN");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                NodeList nodeList2 = ((Element)node).getElementsByTagName("FILE");
                NodeList nodeList3 = ((Element)node).getElementsByTagName("INSTANCE");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string = nodeList2.item(j).getChildNodes().item(0).getNodeValue();
                    String string2 = null;
                    if (nodeList3.item(j).getChildNodes().item(0) != null) {
                        string2 = nodeList3.item(j).getChildNodes().item(0).getNodeValue();
                    }
                    if (!this.instanceToTrackMap.containsKey(string2)) {
                        this.instanceToTrackMap.put(string2, ++n);
                    }
                    this.fileToInstanceMap.put(string, string2);
                }
            }
            System.out.println("InstanceToTrackMap : " + this.instanceToTrackMap);
            System.out.println("FileToInstanceMap : " + this.fileToInstanceMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("File not found : ");
            Properties.getInstance();
            System.out.println(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("ASMALERTS_MERGED").append(File.separator).append("files_qscan_out.xml").toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processMergedFilesDB() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MyHandler myHandler = new MyHandler();
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            sAXParser.parse(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("DBALERTS_MERGED").append(File.separator).append("parser_out.xml").toString(), (DefaultHandler)myHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("File not found : ");
            Properties.getInstance();
            System.out.println(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("DBALERTS_MERGED").append(File.separator).append("parser_out.xml").toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processMergedFilesASM() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MyHandler myHandler = new MyHandler();
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            sAXParser.parse(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("ASMALERTS_MERGED").append(File.separator).append("parser_out.xml").toString(), (DefaultHandler)myHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("File not found : ");
            Properties.getInstance();
            System.out.println(stringBuilder.append(Properties.tfaHome).append(File.separator).append("plugin_output").append(File.separator).append("ASMALERTS_MERGED").append(File.separator).append("parser_out.xml").toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void createJSONFromXML() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.jsonFileName, true));
            int n = 0;
            for (String string : this.allEvents.keySet()) {
                ++n;
                Map<String, String> map = this.allEvents.get(string);
                if (string == null || map == null) continue;
                for (String string2 : map.keySet()) {
                    String string3 = map.get(string2);
                    if (string3.contains("\"")) {
                        string3 = string3.replaceAll("\"", "\\'");
                    }
                    string3 = string3 + "&lt;br/&gt;" + "instance : " + string2 + "&lt;br/&gt;";
                    String string4 = this.getIconForStr(string3);
                    int n2 = this.instanceToTrackMap.get(string2);
                    Date date = this.dateFormat.parse(string);
                    if (n == this.allEvents.size()) {
                        bufferedWriter.write("{\"start\":\"" + date + "\", \"end\":\"" + date + "\", \"durationEvent\":false, \"icon\":\"" + string4 + "\", \"trackNum\":\"" + n2 + "\", \"description\":\"" + string3 + "\", \"caption\":\"" + string3 + "\"},");
                        continue;
                    }
                    bufferedWriter.write("{\"start\":\"" + date + "\", \"end\":\"" + date + "\", \"durationEvent\":false, \"icon\":\"" + string4 + "\", \"trackNum\":\"" + n2 + "\", \"description\":\"" + string3 + "\", \"caption\":\"" + string3 + "\"},");
                }
            }
            bufferedWriter.write("]}");
            bufferedWriter.close();
            this.createZonesInfo();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string != null) {
            SimileJSON simileJSON = new SimileJSON();
        }
    }

    private String getIconForStr(String string) {
        String string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/media-record-3.png";
        if (string.contains("Starting ORACLE instance")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-up-double-3.png";
        } else if (string.contains("Shutting down instance") || string.contains("Instance terminated by")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-down-double-3.png";
        } else if (string.contains("Reconfig Started")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/view-refresh-7.png";
        } else if (string.contains("Reconfig end")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/view-refresh-2.png";
        } else if (string.contains("ORA-00600") || string.contains("ORA-03137") || string.contains("ORA-00469") || string.contains("ORA-1092")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/emblem-important-3.png";
        } else if (string.contains("was mounted")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/edit-redo-3.png";
        } else if (string.contains("was dismounted")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/edit-undo-3.png";
        } else if (string.contains("Database mounted in Shared Mode")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/computer-server-rack_mount.png";
        } else if (string.contains("Global Enqueue Services Deadlock detected")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/emblem-important-red.png";
        } else if (string.contains("TNS-12547") || string.contains("TNS-12599")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/flag-yellow.png";
        } else if (string.contains("Remote instance kill is issued ")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/flag.png";
        } else if (string.contains("Completed redo scan")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/zoom-5.png";
        } else if (string.contains("Instance shutdown complete")) {
            string2 = "http://dadvip0001.us.oracle.com/tfaweb/icons/kshutdown.png";
        }
        return string2;
    }

    private synchronized void createZonesInfo() throws IOException {
        int n;
        String string2;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Date> hashMap2 = new HashMap<Integer, Date>();
        for (String string2 : this.allEvents.keySet()) {
            try {
                Date date = this.dateFormat.parse(string2);
                int n2 = (int)(date.getTime() / 60000L);
                if (hashMap.containsKey(n2)) {
                    n = (Integer)hashMap.get(n2);
                    hashMap.put(n2, n += this.allEvents.get(string2).size());
                    continue;
                }
                hashMap2.put(n2, date);
                hashMap.put(n2, this.allEvents.get(string2).size());
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(stringBuilder.append(Properties.inventoryDir).append(File.separator).append("zones.txt").toString()));
        bufferedWriter.write("[");
        string2 = "";
        for (Integer n3 : hashMap.keySet()) {
            n = (Integer)hashMap.get(n3);
            int n4 = 15;
            if (n == 1) continue;
            if (n == 2) {
                n4 = 30;
            } else if (n > 5) {
                n4 = 5;
            }
            Date date = (Date)hashMap2.get(n3);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(13, 0);
            Date date2 = calendar.getTime();
            calendar.add(12, 1);
            Date date3 = calendar.getTime();
            string2 = string2 + "{ start: \"" + date2 + "\",\n " + "end: \"" + date3 + "\", \n" + "magnify: " + n + ", \n " + "multiple: " + n4 + ", \n " + "unit: Timeline.DateTime.SECOND \n },";
        }
        if (string2.length() > 0) {
            bufferedWriter.write(string2.substring(0, string2.length() - 1));
        }
        bufferedWriter.write("]");
        bufferedWriter.close();
    }

    private class MyHandler
    extends DefaultHandler {
        boolean isEvent = false;
        boolean isLine = false;
        String instance = null;
        String timestamp = null;
        Map<String, String> eventMap = null;

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equalsIgnoreCase("event")) {
                this.isEvent = true;
                this.timestamp = attributes.getValue("time");
                if (this.timestamp != null && this.timestamp.length() > 0) {
                    this.eventMap = new HashMap<String, String>();
                }
            }
            if (string3.equalsIgnoreCase("line")) {
                this.isLine = true;
                this.instance = attributes.getValue("inst");
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.isEvent && this.timestamp != null && this.timestamp.length() > 0) {
                SimileJSON.this.allEvents.put(this.timestamp, this.eventMap);
            }
            if (this.isLine) {
                String string = new String(cArray, n, n2);
                if ((string = string.trim()).length() > 0 && this.eventMap != null) {
                    if (this.eventMap.containsKey(this.instance)) {
                        this.eventMap.put(this.instance, this.eventMap.get(this.instance).concat("&lt;br/&gt;" + string));
                    } else {
                        this.eventMap.put(this.instance, string);
                    }
                }
            }
        }
    }
}

