/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.rat.tfa.type.ProblemSet;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProblemSetXMLReader {
    private static ProblemSetXMLReader instance;
    private static Vector<ProblemSet> problemSets;

    private ProblemSetXMLReader() {
        ProblemSetXMLReader.setup();
    }

    public static ProblemSetXMLReader getInstance() {
        if (instance == null) {
            instance = new ProblemSetXMLReader();
        }
        return instance;
    }

    private static void setup() {
        problemSets = new Vector();
        ProblemSetXMLReader.processXML(problemSets);
    }

    public static void processXML(Vector<ProblemSet> vector) {
        Properties.getInstance();
        File file = new File(Properties.problemSetsXml);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("problemset");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                String string = namedNodeMap.getNamedItem("id").getNodeValue();
                String string2 = namedNodeMap.getNamedItem("description").getNodeValue();
                ProblemSet problemSet = new ProblemSet(string, string2);
                ArrayList<String> arrayList = new ArrayList<String>();
                Element element = (Element)((Element)nodeList.item(i)).getElementsByTagName("tasks").item(0);
                String string3 = element.getChildNodes().item(0).getNodeValue();
                if (string3.contains(",")) {
                    String[] stringArray;
                    for (String string4 : stringArray = string3.split(",")) {
                        arrayList.add(string4);
                    }
                } else {
                    arrayList.add(string3.trim());
                }
                problemSet.setTaskIds(arrayList);
                vector.add(problemSet);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Output.print("ProblemSetXMLReader : ParserConfigurationException in processing problem sets");
        }
        catch (SAXException sAXException) {
            Output.print("ProblemSetXMLReader : SAXException in processing problem sets");
        }
        catch (IOException iOException) {
            Output.print("ProblemSetXMLReader : IOException in processing problem sets");
        }
    }

    public static int getNumberOfProblemSets() {
        ProblemSetXMLReader.setup();
        return problemSets.size();
    }

    public static List<String> getTaskIdsForProblem(String string) {
        if (string != null) {
            int n = new Integer(string);
            return problemSets.get(n - 1).getTaskIds();
        }
        return null;
    }

    public static void listProblemSets(PrintWriter printWriter) {
        ProblemSetXMLReader.setup();
        int n = 1;
        for (ProblemSet problemSet : problemSets) {
            printWriter.println(n + ". " + problemSet.getDescription());
            ++n;
        }
        printWriter.println("What would you like to do? Choose an option between [1, " + problemSets.size() + "] :");
    }

    public static void listProblemSets() {
        ProblemSetXMLReader.setup();
        for (ProblemSet problemSet : problemSets) {
            System.out.println("-------------------------------------");
            System.out.println("Id : " + problemSet.getId());
            System.out.println("Description : " + problemSet.getDescription());
            System.out.println("Task Ids : " + problemSet.getTaskIds());
            System.out.println("-------------------------------------");
        }
    }

    public static void main(String[] stringArray) {
    }
}

