/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.rat.tfa.type.MaskString;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MaskStringsXMLReader {
    public static void processXML(Vector<MaskString> vector) {
        try {
            boolean bl = false;
            File file = new File(Properties.maskStringsXml);
            if (file.exists()) {
                if (file.length() == 0L) {
                    file.delete();
                    return;
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                document.getDocumentElement().normalize();
                Output.printTrace("Root element " + document.getDocumentElement().getNodeName(), 3);
                NodeList nodeList = document.getElementsByTagName("mask_string");
                Output.printTrace("Information of all Mask Strings", 3);
                Output.printTrace("Length: " + nodeList.getLength(), 3);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Output.printTrace("---------------------------------------", 3);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    NodeList nodeList2 = element.getElementsByTagName("original");
                    Element element2 = (Element)nodeList2.item(0);
                    String string = element2.getChildNodes().item(0).getNodeValue();
                    NodeList nodeList3 = element.getElementsByTagName("replacement");
                    Element element3 = (Element)nodeList3.item(0);
                    String string2 = element3.getChildNodes().item(0).getNodeValue();
                    if (!string.equalsIgnoreCase("dummy1") && !string.equalsIgnoreCase("dummy2")) {
                        MaskString maskString = new MaskString();
                        maskString.setOriginal(string);
                        maskString.setReplacement(string2);
                        Output.printTrace("Added Mask String", 3);
                        vector.add(maskString);
                        continue;
                    }
                    bl = true;
                }
                if (bl && vector.size() == 0) {
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            Output.print("MaskStringsXMLReader : Exception in processing mask strings");
        }
    }

    public static void main(String[] stringArray) {
        Vector<MaskString> vector = new Vector<MaskString>();
        MaskStringsXMLReader.processXML(vector);
        System.out.println(vector);
        for (MaskString maskString : vector) {
            System.out.println("original : " + maskString.getOriginal());
            System.out.println("replacement : " + maskString.getReplacement());
        }
    }
}

