/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.rat.tfa.type.LogType;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InventoryXMLReader {
    private static InventoryXMLReader instance;
    private List<String> fileNames;
    private List<LogType> logTypes;

    private InventoryXMLReader() {
        this.setup();
    }

    public InventoryXMLReader(List<LogType> list) {
        this.logTypes = new ArrayList<LogType>(list);
    }

    public static InventoryXMLReader getInstance() {
        if (instance == null) {
            instance = new InventoryXMLReader();
        }
        return instance;
    }

    private void setup() {
        this.processXML();
    }

    private void processXML() {
        File file = new File(Properties.inventoryXMLFile);
        this.fileNames = new ArrayList<String>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("file");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("file_name");
                Element element2 = (Element)nodeList2.item(0);
                NodeList nodeList3 = element2.getChildNodes();
                String string = nodeList3.item(0).getNodeValue();
                this.fileNames.add(string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Output.print("InventoryXMLReader : ParserConfigurationException in processing inventory.xml");
        }
        catch (SAXException sAXException) {
            Output.print("InventoryXMLReader : SAXException in processing inventory.xml");
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            Output.print("InventoryXMLReader : IOException in processing inventory.xml");
        }
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public List<String> getFilesOfRequestedType() {
        File file = new File(Properties.inventoryXMLFile);
        this.fileNames = new ArrayList<String>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("file");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("file_type");
                Element element2 = (Element)nodeList2.item(0);
                if (!this.logTypes.get(0).getLogType().equals(element2.getTextContent())) continue;
                NodeList nodeList3 = element.getElementsByTagName("file_name");
                Element element3 = (Element)nodeList3.item(0);
                NodeList nodeList4 = element3.getChildNodes();
                String string = nodeList4.item(0).getNodeValue();
                this.fileNames.add(string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Output.print("InventoryXMLReader : ParserConfigurationException in processing inventory.xml");
        }
        catch (SAXException sAXException) {
            Output.print("InventoryXMLReader : SAXException in processing inventory.xml");
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            Output.print("InventoryXMLReader : IOException in processing inventory.xml");
        }
        return this.fileNames;
    }

    public static void main(String[] stringArray) {
        LogType logType = new LogType();
        ArrayList<LogType> arrayList = new ArrayList<LogType>();
        if (stringArray.length == 0) {
            InventoryXMLReader inventoryXMLReader = InventoryXMLReader.getInstance();
            System.out.println(inventoryXMLReader.getFileNames());
        } else {
            logType.setLogType(stringArray[0]);
            logType.setDbName(stringArray[1]);
            arrayList.add(logType);
            InventoryXMLReader inventoryXMLReader = new InventoryXMLReader(arrayList);
            System.out.println(inventoryXMLReader.getFilesOfRequestedType());
        }
    }
}

