/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.rat.tfa.entity.InstanceStartup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstanceStartupXMLReader {
    private List<InstanceStartup> instanceStartupEntities;

    public InstanceStartupXMLReader(String string) {
        this.setup(string);
    }

    private void setup(String string) {
        try {
            String string2 = "EEE MMM dd HH:mm:ss zzz yyyy";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            this.instanceStartupEntities = new ArrayList<InstanceStartup>();
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            this.createInstanceStartupEntities(document, simpleDateFormat);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createInstanceStartupEntities(Document document, DateFormat dateFormat) {
        NodeList nodeList = document.getElementsByTagName("startups");
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("name");
            NodeList nodeList3 = element2.getElementsByTagName("startup");
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Node node2 = nodeList3.item(j);
                if (node2.getNodeType() != 1) continue;
                Element element3 = (Element)node2;
                NodeList nodeList4 = element3.getElementsByTagName("eventid");
                Element element4 = (Element)nodeList4.item(0);
                NodeList nodeList5 = element4.getChildNodes();
                String string2 = nodeList5.item(0).getNodeValue();
                NodeList nodeList6 = element3.getElementsByTagName("startuptime");
                Element element5 = (Element)nodeList6.item(0);
                NodeList nodeList7 = element5.getChildNodes();
                String string3 = nodeList7.item(0).getNodeValue();
                Date date = null;
                try {
                    if (!string3.equals("null")) {
                        date = dateFormat.parse(string3);
                    }
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                NodeList nodeList8 = element3.getElementsByTagName("dummy");
                Element element6 = (Element)nodeList8.item(0);
                NodeList nodeList9 = element6.getChildNodes();
                String string4 = nodeList9.item(0).getNodeValue();
                InstanceStartup instanceStartup = new InstanceStartup(string, date, string4, string2);
                this.instanceStartupEntities.add(instanceStartup);
            }
        }
    }

    public List<InstanceStartup> getInstanceStartupEntities() {
        return this.instanceStartupEntities;
    }

    public static void main(String[] stringArray) {
        InstanceStartupXMLReader instanceStartupXMLReader = new InstanceStartupXMLReader("C:\\Users\\amchaura.ORADEV\\TFA\\rws3060024_InstanceStartup.xml");
        for (InstanceStartup instanceStartup : instanceStartupXMLReader.getInstanceStartupEntities()) {
            instanceStartup.print();
        }
    }
}

