/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GPNPProfileXMLReader {
    private static GPNPProfileXMLReader instance;
    private String hashKey = null;
    private String clusterUId = null;

    private GPNPProfileXMLReader() {
        this.setup();
    }

    private GPNPProfileXMLReader(String string) {
        this.setup(string);
    }

    public static GPNPProfileXMLReader getInstance() {
        if (instance == null) {
            instance = new GPNPProfileXMLReader();
        }
        return instance;
    }

    private void setup() {
        this.processXML(Properties.crsHome);
    }

    private void setup(String string) {
        this.processXML(string);
    }

    private void processXML(String string) {
        if (string != null) {
            File file = new File(string + File.separator + "gpnp" + File.separator + "profiles" + File.separator + "peer" + File.separator + "profile.xml");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                document.getDocumentElement().normalize();
                this.clusterUId = document.getDocumentElement().getAttribute("ClusterUId");
                String string2 = document.getDocumentElement().getAttribute("ClusterName");
                this.hashKey = this.clusterUId + string2;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Output.print("GPNPProfileXMLReader : ParserConfigurationException in processing profile.xml");
            }
            catch (SAXException sAXException) {
                Output.print("GPNPProfileXMLReader : SAXException in processing profile.xml");
            }
            catch (IOException iOException) {
                Output.print("GPNPProfileXMLReader : IOException in processing profile.xml");
            }
        } else {
            Output.print("GPNPProfileXMLReader : CRSHome is not set. Cannot get hashkey");
        }
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public String getClusterUId() {
        return this.clusterUId;
    }

    public static void main(String[] stringArray) {
        GPNPProfileXMLReader gPNPProfileXMLReader = new GPNPProfileXMLReader(stringArray[0]);
        System.out.println(gPNPProfileXMLReader.getClusterUId());
    }
}

