/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.rat.tfa.type.FileType;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTypePatternXMLReader {
    public static void processXML(Vector<FileType> vector, String string) {
        try {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            Output.printTrace("Root element " + document.getDocumentElement().getNodeName(), 3);
            NodeList nodeList = document.getElementsByTagName("file_type");
            Output.printTrace("Information of all file type patterns", 3);
            Output.printTrace("Length: " + nodeList.getLength(), 3);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Object object2;
                NodeList nodeList2;
                NodeList nodeList3;
                Object object3;
                int n;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                FileType fileType = new FileType();
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                NodeList nodeList4 = element.getElementsByTagName("name");
                Element element2 = (Element)nodeList4.item(0);
                NodeList nodeList5 = element2.getChildNodes();
                String string2 = nodeList5.item(0).getNodeValue();
                Output.printTrace("Name : " + string2, 3);
                fileType.setName(string2);
                NodeList nodeList6 = element.getElementsByTagName("inventory_action");
                if (nodeList6 != null && (object8 = (Element)nodeList6.item(0)) != null && (object7 = object8.getChildNodes()) != null) {
                    object6 = object7.item(0).getNodeValue();
                    Output.printTrace("Inventory Action : " + (String)object6, 3);
                    fileType.setInventoryAction((String)object6);
                }
                if ((object8 = element.getElementsByTagName("date_formats")) != null && (object7 = (Element)object8.item(0)) != null) {
                    object6 = object7.getElementsByTagName("date_format");
                    object5 = null;
                    if (object6 != null) {
                        object4 = new HashSet();
                        for (n = 0; n < object6.getLength(); n += 1) {
                            object3 = (Element)object6.item(n);
                            nodeList3 = object3.getChildNodes();
                            if (nodeList3 == null || nodeList3.item(0) == null || (object5 = nodeList3.item(0).getNodeValue()) == null || ((String)object5).equals("")) continue;
                            Output.printTrace("dateformatValue : " + (String)object5, 3);
                            object4.add(object5);
                        }
                        fileType.setDatePatterns((Set<String>)object4);
                    }
                }
                if ((object7 = element.getElementsByTagName("category")) != null && (object6 = (Element)object7.item(0)) != null && (object5 = object6.getChildNodes()) != null) {
                    object4 = object5.item(0).getNodeValue();
                    Output.printTrace("Category Value : " + (String)object4, 3);
                    fileType.setCategory((String)object4);
                }
                if ((object6 = element.getElementsByTagName("component")) != null && (object5 = (Element)object6.item(0)) != null && (object4 = object5.getChildNodes()) != null) {
                    String string3 = object4.item(0).getNodeValue();
                    Output.printTrace("Component Value : " + string3, 3);
                    fileType.setComponent(string3);
                }
                if ((object5 = element.getElementsByTagName("also_collect_for")) != null && (object4 = (Element)object5.item(0)) != null && (nodeList2 = object4.getChildNodes()) != null && nodeList2.item(0) != null) {
                    object3 = nodeList2.item(0).getNodeValue();
                    Output.printTrace("Also collect for Value : ", 3);
                    fileType.setAlsoCollectFor((String)object3);
                }
                object4 = element.getElementsByTagName("use_df_only");
                n = 0;
                if (object4 != null && (object3 = (Element)object4.item(0)) != null) {
                    nodeList3 = object3.getChildNodes();
                    int n2 = Integer.valueOf(nodeList3.item(0).getNodeValue());
                    if (n2 == 1) {
                        n = 1;
                    }
                    Output.printTrace("use df only: " + (n != 0), 3);
                }
                fileType.setUseDfOnly(n != 0);
                object3 = element.getElementsByTagName("keep_header_lines");
                long l = 0L;
                if (object3 != null && (object2 = (Element)object3.item(0)) != null && (object = object2.getChildNodes()) != null && object.getLength() > 0) {
                    l = Long.valueOf(object.item(0).getNodeValue());
                    Output.printTrace("Keep Header Lines : " + l, 3);
                }
                fileType.setKeepHeaderLines(l);
                object2 = element.getElementsByTagName("patterns");
                object = (Element)object2.item(0);
                NodeList nodeList7 = object.getElementsByTagName("pattern");
                Output.printTrace("Pattern Elements Found: " + nodeList7.getLength(), 3);
                for (int j = 0; j < nodeList7.getLength(); ++j) {
                    Element element3 = (Element)nodeList7.item(j);
                    NodeList nodeList8 = element3.getElementsByTagName("type");
                    Element element4 = (Element)nodeList8.item(0);
                    NodeList nodeList9 = element4.getChildNodes();
                    String string4 = nodeList9.item(0).getNodeValue();
                    Output.printTrace("Type : " + string4, 3);
                    NodeList nodeList10 = element3.getElementsByTagName("pattern_text");
                    Element element5 = (Element)nodeList10.item(0);
                    NodeList nodeList11 = element5.getChildNodes();
                    String string5 = nodeList11.item(0).getNodeValue();
                    Output.printTrace("Pattern Text : " + string5, 3);
                    if (string4.equalsIgnoreCase("NAME_PATTERN")) {
                        fileType.addNamePattern(string5);
                        Output.printTrace("Added Name Pattern", 3);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("CONTENTS_PATTERN")) {
                        fileType.addContentPattern(string5);
                        Output.printTrace("Added Content Pattern", 3);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("DIRECTORY_PATTERN")) continue;
                    fileType.addDirPathPattern(string5);
                    Output.printTrace("Added Directory Pattern", 3);
                }
                vector.add(fileType);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void listFileTypes(Vector<FileType> vector) {
        for (FileType fileType : vector) {
            Output.print("-------------------------------------");
            Output.print("NAME: " + fileType.getName());
            fileType.listPatterns();
        }
    }

    public static void main(String[] stringArray) {
        Vector<FileType> vector = new Vector<FileType>();
        FileTypePatternXMLReader.processXML(vector, "C:\\Users\\amchaura.ORADEV\\TFA\\file_type_patterns.xml");
        FileTypePatternXMLReader.listFileTypes(vector);
    }

    public static String testFileType() {
        Vector<FileType> vector = new Vector<FileType>();
        FileTypePatternXMLReader.processXML(vector, Properties.fileTypesXml);
        for (FileType fileType : vector) {
            try {
                int n = fileType.getNumberNamePatterns();
                if (n <= 0) continue;
                fileType.checkNamePatterns("blah");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Output.print("FileTypePatternXMLReader : PatternSyntaxException in checking file type");
                return fileType.getName();
            }
            catch (Exception exception) {
                Output.print("FileTypePatternXMLReader : Exception in checking file type");
                return fileType.getName();
            }
        }
        return "";
    }
}

