/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import oracle.rat.tfa.analysis.handleAlertClusterEviction;
import oracle.rat.tfa.analysis.handleAlertClusterReconfiguration;
import oracle.rat.tfa.analysis.handleAlertDbGeneralError;
import oracle.rat.tfa.analysis.handleAlertDbParameter;
import oracle.rat.tfa.analysis.handleAlertDbStartShut;
import oracle.rat.tfa.analysis.handleGeneric;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class DumpXml {
    public static void DumpAllXml() {
        DumpXml.DumpAllXml(Properties.getInstance());
    }

    public static Map<String, Integer> DumpSimileData(String string, Map<String, String> map, Map<String, Integer> map2) {
        Map<String, Integer> map3 = null;
        try {
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("{");
            bufferedWriter.write("\"events\":[");
            handleAlertDbStartShut.dumpSimileJSON(bufferedWriter, map, map2);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Output.print("DumpXml: IOException in dumping JSON data for simile");
        }
        return map3;
    }

    public static void DumpSimileXml(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<data>\n");
            handleAlertDbStartShut.dumpShutdownSimileXml(bufferedWriter);
            handleAlertDbParameter.dumpSimileXml(bufferedWriter);
            handleAlertDbGeneralError.dumpSimileXml(bufferedWriter);
            handleAlertClusterReconfiguration.dumpSimileXml(bufferedWriter);
            bufferedWriter.write("</data>");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Output.print("DumpXml : IOException in writing simile XML");
        }
    }

    public static void DumpAllXml(Properties properties) {
        DbGet dbGet = DbManager.getInstance().getDbGet();
        String string = new Host().getHostname().trim();
        String string2 = Properties.inventoryDir + File.separator;
        try {
            FileWriter fileWriter = new FileWriter(string2 + string + "_InstanceStartup.xml");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<dbalertlogs>\n");
            handleAlertDbStartShut.dumpStartXml(bufferedWriter);
            bufferedWriter.write("</dbalertlogs>\n");
            bufferedWriter.close();
            fileWriter.close();
            fileWriter = new FileWriter(string2 + string + "_InstanceShutdown.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<dbalertlogs>\n");
            handleAlertDbStartShut.dumpShutXml(bufferedWriter);
            bufferedWriter.write("</dbalertlogs>\n");
            bufferedWriter.close();
            fileWriter.close();
            fileWriter = new FileWriter(string2 + string + "_DatabaseParameter.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<dbalertlogs>\n");
            handleAlertDbParameter.dumpXml(bufferedWriter);
            bufferedWriter.write("</dbalertlogs>\n");
            bufferedWriter.close();
            fileWriter.close();
            fileWriter = new FileWriter(string2 + string + "_DatabaseGeneralError.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<dbalertlogs>\n");
            handleAlertDbGeneralError.dumpXml(bufferedWriter);
            bufferedWriter.write("</dbalertlogs>\n");
            bufferedWriter.close();
            fileWriter.close();
            fileWriter = new FileWriter(string2 + string + "_AlertClusterReconfiguration.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<clusteralertlogs>\n");
            handleAlertClusterReconfiguration.dumpXml(dbGet, bufferedWriter);
            bufferedWriter.write("</clusteralertlogs>\n");
            bufferedWriter.close();
            fileWriter.close();
            fileWriter = new FileWriter(string2 + string + "_AlertClusterEviction.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            bufferedWriter.write("<clusteralertlogs>\n");
            handleAlertClusterEviction.dumpXml(bufferedWriter);
            bufferedWriter.write("</clusteralertlogs>\n");
            bufferedWriter.close();
            fileWriter.close();
            fileWriter = new FileWriter(string2 + string + "_GenericEvent.xml");
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n ");
            handleGeneric.dumpXml(bufferedWriter);
            bufferedWriter.close();
            fileWriter.close();
            FileEntity.dumpFilesFromStoreToXML();
        }
        catch (Exception exception) {
            Output.print("DumpXml : Exception in writing XML file");
        }
    }

    public static void main(String[] stringArray) {
        DumpXml.DumpAllXml();
    }
}

