/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.rat.tfa.type.DateFormatType;
import oracle.rat.tfa.util.Output;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatePatternXMLReader {
    public static void test(Vector<DateFormatType> vector) {
        for (DateFormatType dateFormatType : vector) {
            Pattern pattern = dateFormatType.getDatePattern();
            String string = dateFormatType.getExampleDate();
            String string2 = dateFormatType.getKey();
            Output.printTrace("Testing key " + string2 + " using datePattern: " + pattern.pattern() + " and example date string: " + string, 3);
            Scanner scanner = new Scanner(string);
            scanner.findInLine(pattern);
            MatchResult matchResult = scanner.match();
            for (int i = 1; i <= matchResult.groupCount(); ++i) {
                String string3 = matchResult.group(i);
                try {
                    Date date = dateFormatType.getDate(string3.trim());
                    continue;
                }
                catch (ParseException parseException) {
                    Output.print("DatePatternXMLReader : ParseException in formatting date string");
                }
            }
        }
    }

    public static void processXML(Vector<DateFormatType> vector, String string) {
        try {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            Output.printTrace("Root element " + document.getDocumentElement().getNodeName(), 3);
            NodeList nodeList = document.getElementsByTagName("pattern");
            Output.printTrace("Information of all patterns", 3);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("key");
                Element element2 = (Element)nodeList2.item(0);
                NodeList nodeList3 = element2.getChildNodes();
                String string2 = nodeList3.item(0).getNodeValue();
                Output.printTrace("********************************************", 3);
                Output.printTrace("Key : " + string2, 3);
                NodeList nodeList4 = element.getElementsByTagName("regex");
                Element element3 = (Element)nodeList4.item(0);
                NodeList nodeList5 = element3.getChildNodes();
                String string3 = nodeList5.item(0).getNodeValue();
                Output.printTrace("Regex : " + string3, 3);
                NodeList nodeList6 = element.getElementsByTagName("format_mask");
                Element element4 = (Element)nodeList6.item(0);
                NodeList nodeList7 = element4.getChildNodes();
                String string4 = nodeList7.item(0).getNodeValue();
                Output.printTrace("Format Mask : " + string4, 3);
                NodeList nodeList8 = element.getElementsByTagName("example");
                Element element5 = (Element)nodeList8.item(0);
                NodeList nodeList9 = element5.getChildNodes();
                String string5 = nodeList9.item(0).getNodeValue();
                Output.printTrace("Example : " + string5, 3);
                DateFormatType dateFormatType = new DateFormatType(string2, string3, string4, string5);
                vector.add(dateFormatType);
            }
        }
        catch (Exception exception) {
            Output.print("DatePatternXMLReader : Exception while processing date patterns");
        }
    }
}

