/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.xml;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.rat.tfa.analysis.Globals.hAlrtDbGenErr;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DatabaseGeneralErrorXMLReader {
    private List<DatabaseGeneralError> databaseGeneralErrorEntities;

    public DatabaseGeneralErrorXMLReader(String string) {
        this.setup(string);
    }

    private void setup(String string) {
        try {
            String string2 = "EEE MMM dd HH:mm:ss zzz yyyy";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            this.databaseGeneralErrorEntities = new ArrayList<DatabaseGeneralError>();
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            this.createDatabaseGeneralErrorEntities(document, simpleDateFormat);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createDatabaseGeneralErrorEntities(Document document, DateFormat dateFormat) {
        NodeList nodeList = document.getElementsByTagName("databasegeneralerrors");
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("name");
            NodeList nodeList3 = element2.getElementsByTagName("dbgeneralerror");
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Node node2 = nodeList3.item(j);
                if (node2.getNodeType() != 1) continue;
                Element element3 = (Element)node2;
                NodeList nodeList4 = element2.getElementsByTagName("eventid");
                Element element4 = (Element)nodeList4.item(0);
                NodeList nodeList5 = element4.getChildNodes();
                String string2 = nodeList5.item(0).getNodeValue();
                NodeList nodeList6 = element3.getElementsByTagName("startuptime");
                Element element5 = (Element)nodeList6.item(0);
                NodeList nodeList7 = element5.getChildNodes();
                String string3 = nodeList7.item(0).getNodeValue();
                Date date = null;
                try {
                    if (!string3.equals("null")) {
                        date = dateFormat.parse(string3);
                    }
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                NodeList nodeList8 = element3.getElementsByTagName("errorcode");
                Element element6 = (Element)nodeList8.item(0);
                NodeList nodeList9 = element6.getChildNodes();
                String string4 = nodeList9.item(0).getNodeValue();
                NodeList nodeList10 = element3.getElementsByTagName("errortext");
                Element element7 = (Element)nodeList10.item(0);
                NodeList nodeList11 = element7.getChildNodes();
                String string5 = nodeList11.item(0).getNodeValue();
                NodeList nodeList12 = element3.getElementsByTagName("errortime");
                Element element8 = (Element)nodeList12.item(0);
                NodeList nodeList13 = element8.getChildNodes();
                String string6 = nodeList13.item(0).getNodeValue();
                Date date2 = null;
                try {
                    if (!string6.equals("null")) {
                        date2 = dateFormat.parse(string6);
                    }
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                NodeList nodeList14 = element3.getElementsByTagName("tracefile");
                Element element9 = (Element)nodeList14.item(0);
                NodeList nodeList15 = element9.getChildNodes();
                String string7 = nodeList15.item(0).getNodeValue();
                hAlrtDbGenErr hAlrtDbGenErr2 = new hAlrtDbGenErr();
                if (string7.equals("NONE")) {
                    hAlrtDbGenErr2.setFileName(string7);
                }
                DatabaseGeneralError databaseGeneralError = new DatabaseGeneralError(string, date, date2, string4, string5, hAlrtDbGenErr2, string2);
                this.databaseGeneralErrorEntities.add(databaseGeneralError);
            }
        }
    }

    public List<DatabaseGeneralError> getDatabaseGeneralErrorEntities() {
        return this.databaseGeneralErrorEntities;
    }

    public static void main(String[] stringArray) {
        DatabaseGeneralErrorXMLReader databaseGeneralErrorXMLReader = new DatabaseGeneralErrorXMLReader("C:\\Users\\amchaura.ORADEV\\TFA\\rws3060024_DatabaseGeneralError.xml");
        for (DatabaseGeneralError databaseGeneralError : databaseGeneralErrorXMLReader.getDatabaseGeneralErrorEntities()) {
            databaseGeneralError.print();
        }
    }
}

