/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.rat.tfa.view.LogArea;

public class TreeView
extends JPanel
implements TreeWillExpandListener {
    private JTree tree;
    private File homeDirectory;
    private ArrayList<File> selectedFiles = new ArrayList();
    private int selection = 4;
    private LogArea logArea;
    private String title;

    public TreeView(File file, int n, String string) {
        try {
            this.homeDirectory = file;
            this.selection = n;
            this.title = string;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.logArea = LogArea.getInstance();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeView.this.onOk(actionEvent);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeView.this.onCancel(actionEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add((Component)jButton, null);
        jPanel.add((Component)jButton2, null);
        this.add((Component)jPanel, "South");
        this.tree = new JTree(this.addNodes(null, this.homeDirectory));
        this.tree.addTreeWillExpandListener(this);
        this.tree.setAutoscrolls(true);
        this.tree.getSelectionModel().setSelectionMode(this.selection);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setAutoscrolls(true);
        jScrollPane.getViewport().add((Component)this.tree, null);
        this.add((Component)jScrollPane, "Center");
        if (this.title != null && this.title.length() != 0) {
            Border border = BorderFactory.createEmptyBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.title);
            titledBorder.setTitleJustification(2);
            this.setBorder(titledBorder);
        }
    }

    private DefaultMutableTreeNode addSingleChild(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        Collections.sort(vector, String.CASE_INSENSITIVE_ORDER);
        Vector<File> vector2 = new Vector<File>();
        for (String object : vector) {
            File file2 = new File(file.getPath() + File.separator + object);
            if (file2.isDirectory()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new File(file2.getName()));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            vector2.add(new File(object));
        }
        for (File file3 : vector2) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(file3));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode addNodes(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        String[] stringArray;
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(file);
        }
        if ((stringArray = file.list()) == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        Collections.sort(vector, String.CASE_INSENSITIVE_ORDER);
        Vector<File> vector2 = new Vector<File>();
        for (String object : vector) {
            File file2 = new File(file.getPath() + File.separator + object);
            if (file2.isDirectory()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new File(file2.getName()));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.addSingleChild(defaultMutableTreeNode2, file2);
                continue;
            }
            vector2.add(new File(object));
        }
        for (File file3 : vector2) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(file3));
        }
        return defaultMutableTreeNode;
    }

    public ArrayList<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    protected void onOk(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            this.logArea.append("No files have been selected.");
            return;
        }
        for (TreePath treePath : treePathArray) {
            Object[] objectArray = treePath.getPath();
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object : objectArray) {
                stringBuffer.append(object + File.separator);
            }
            File file = new File(stringBuffer.toString());
            if (file.canRead()) {
                if (file.isDirectory()) {
                    int n = 0;
                    for (File file2 : file.listFiles()) {
                        if (!file2.canRead()) continue;
                        ++n;
                    }
                    if (n == 0) {
                        this.logArea.append("User does not have read permissions for the files in directory : " + file.getName());
                        continue;
                    }
                    this.selectedFiles.add(new File(stringBuffer.toString()));
                    continue;
                }
                this.selectedFiles.add(new File(stringBuffer.toString()));
                continue;
            }
            if (file.isDirectory()) {
                this.logArea.append("User does not have read permission for the directory : " + file.getName());
                continue;
            }
            this.logArea.append("User does not have read permission for the file : " + file.getName());
        }
        this.setVisible(false);
    }

    protected void onCancel(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        defaultMutableTreeNode.removeAllChildren();
        Object[] objectArray = treeExpansionEvent.getPath().getPath();
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : objectArray) {
            stringBuffer.append(object + File.separator);
        }
        this.addNodes(defaultMutableTreeNode, new File(stringBuffer.toString()));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }
}

