/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.rat.tfa.view.TFAFrame;

public class TraceFileAnalyzer {
    private static String tfaHome = null;
    private static File file;
    private static FileLock fileLock;
    private static FileChannel fileChannel;

    private void showTFAFrame() {
        TFAFrame tFAFrame = TFAFrame.getInstance(tfaHome);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = tFAFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        tFAFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        tFAFrame.setVisible(true);
    }

    private static void unlockFile() {
        try {
            if (fileLock != null) {
                System.out.println("trying to release analyzer lock and delete file...");
                fileLock.release();
                fileChannel.close();
                file.delete();
                fileLock = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
            tfaHome = stringArray.length > 0 ? stringArray[0] : File.separator + "home" + File.separator + "sowsingh" + File.separator + "jdeveloper" + File.separator + "mywork" + File.separator + "repo2_tfahome" + File.separator + "tfa_home";
            file = new File(tfaHome + File.separator + "analyzer.lock");
            fileChannel = new RandomAccessFile(file, "rw").getChannel();
            fileLock = fileChannel.tryLock();
            System.out.println("trying to get lock : " + fileLock);
            if (fileLock == null) {
                fileChannel.close();
                throw new RuntimeException("Only one instance of TraceFileAnalyzer can run.");
            }
            ShutdownHook shutdownHook = new ShutdownHook();
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new TraceFileAnalyzer().showTFAFrame();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            TraceFileAnalyzer.unlockFile();
        }
    }
}

