/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.rat.tfa.db.DataAccessor.ZipEntityDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.ZipEntity;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.view.ActionMonitor;
import oracle.rat.tfa.view.CollectZipsDialog;
import oracle.rat.tfa.view.CollectionMonitor;
import oracle.rat.tfa.view.LogArea;
import oracle.rat.tfa.view.PreferencesDialog;
import oracle.rat.tfa.view.TreeView;

public class TFAFrame
extends JFrame {
    public static final int SUCCESS = 1;
    public static final int FAILED = 0;
    private JPanel mainPanel;
    private JToolBar toolBar = new JToolBar("toolBar", 1);
    private JSplitPane splitPane = new JSplitPane();
    private JMenuBar jMenuBar = new JMenuBar();
    private JMenu applicationMenu;
    private LogArea logArea;
    private String repoSize = "500";
    private File repo;
    private PreferencesDialog preferencesDlg;
    private File tfa_home_dir;
    private File rootDir;
    private JMenuItem startMenuItem;
    private JMenu manageMenu;
    private JMenu runMenu;
    private JMenu toolsMenu;
    ArrayList<Map<String, String>> actionAttributes;
    private boolean clusterwide = true;
    private static TFAFrame instance;

    private TFAFrame(String string) {
        try {
            this.setTFAHome(string);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static TFAFrame getInstance(String string) {
        if (instance == null) {
            instance = new TFAFrame(string);
        }
        return instance;
    }

    public void setTFAHome(String string) {
        this.tfa_home_dir = new File(string);
    }

    public void setClusterWide(boolean bl) {
        this.clusterwide = bl;
    }

    private void jbInit() throws Exception {
        File[] fileArray = File.listRoots();
        if (fileArray != null && fileArray.length > 0) {
            this.rootDir = fileArray[0];
        }
        this.initMenuBar();
        this.createToolBar();
        this.createCenterPanel();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.splitPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.mainPanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(500, 500));
        this.setTitle("Trace File Analyzer");
        this.setJMenuBar(this.jMenuBar);
        this.getContentPane().add((Component)jPanel, "Center");
        this.setDefaultCloseOperation(3);
    }

    private void initMenuBar() {
        Object object;
        boolean bl;
        Object object2;
        this.applicationMenu = new JMenu("Application");
        this.applicationMenu.setMnemonic(65);
        this.manageMenu = new JMenu("Manage");
        this.manageMenu.setMnemonic(77);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        if (new File(File.separator + "etc" + File.separator + "init.d" + File.separator + "init.tfa").exists()) {
            object2 = this.getCurrentUser();
            if (((String)object2).equals("root")) {
                bl = this.isTFARunningAsInit();
                if (bl) {
                    this.addStartOptionToMenu("Stop", "rootStop");
                    this.setMenusEnabled(true);
                } else {
                    this.addStartOptionToMenu("Start", "rootStart");
                    this.setMenusEnabled(false);
                }
            } else {
                bl = this.isTFARunningAsInit();
                if (bl) {
                    System.out.println("User " + (String)object2 + " does not have permission to connect to TFA. Login as root.");
                    System.exit(0);
                } else {
                    System.out.println("User " + (String)object2 + " does not have permission to start TFA through init.tfa. Login as root.");
                    System.exit(0);
                }
            }
        } else {
            System.out.println("init.tfa does not exist");
            object2 = this.getCurrentUser();
            bl = this.isTFARunning();
            if (bl) {
                object = this.getTFAOwner();
                if (((String)object2).equals(object)) {
                    this.addStartOptionToMenu("Stop", "normalStop");
                    this.setMenusEnabled(true);
                } else {
                    System.out.println("User " + (String)object2 + " does not have permission to connect to TFA. Login as " + (String)object);
                }
            } else {
                this.addStartOptionToMenu("Start", "normalStart");
                this.setMenusEnabled(false);
            }
        }
        object2 = new JMenuItem("Exit");
        ((JMenuItem)object2).setAccelerator(KeyStroke.getKeyStroke(115, 8));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.onExit(actionEvent);
            }
        });
        this.applicationMenu.add((JMenuItem)object2);
        JMenu jMenu = new JMenu("Manage Directories");
        object = new JMenuItem("Add Directory");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.addDirectory(actionEvent);
            }
        });
        JMenuItem jMenuItem = new JMenuItem("Remove Directory");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.removeDirectory(actionEvent);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Print Directories");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.printDirectories(actionEvent);
            }
        });
        jMenu.add((JMenuItem)object);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        JMenu jMenu2 = new JMenu("Manage Hosts");
        JMenuItem jMenuItem3 = new JMenuItem("Add Hosts");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.addHosts();
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Print Hosts");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.printHosts(actionEvent);
            }
        });
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem4);
        JMenu jMenu3 = new JMenu("Manage Repository");
        JMenuItem jMenuItem5 = new JMenuItem("Change Repository");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.addRepository(actionEvent);
            }
        });
        JMenuItem jMenuItem6 = new JMenuItem("Set Repository Size (MB)");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.setRepositorySize(actionEvent);
            }
        });
        JMenuItem jMenuItem7 = new JMenuItem("Print Repository");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.printRepository(actionEvent);
            }
        });
        jMenu3.add(jMenuItem5);
        jMenu3.add(jMenuItem6);
        jMenu3.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Manage Collections");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.manageCollections();
            }
        });
        this.manageMenu.add(jMenu);
        this.manageMenu.add(jMenu2);
        this.manageMenu.add(jMenu3);
        this.manageMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Run Inventory");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.showRunInventoryDialog();
            }
        });
        JMenuItem jMenuItem10 = new JMenuItem("Run Scan");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.showRunScanDialog();
            }
        });
        this.runMenu.add(jMenuItem9);
        this.runMenu.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("Collect zip files");
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.collectZipFiles(actionEvent);
            }
        });
        JMenuItem jMenuItem12 = new JMenuItem("Print Actions");
        jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.printActions(TFAFrame.this.getHostName());
            }
        });
        JMenuItem jMenuItem13 = new JMenuItem("Action Monitor");
        jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.showActionMonitor();
            }
        });
        JMenuItem jMenuItem14 = new JMenuItem("Preferences");
        jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.showPreferences(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem11);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(jMenuItem12);
        this.toolsMenu.add(jMenuItem13);
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic(72);
        JMenuItem jMenuItem15 = new JMenuItem("Search");
        JMenuItem jMenuItem16 = new JMenuItem("Table of Contents");
        JMenuItem jMenuItem17 = new JMenuItem("Documentation Library");
        JMenuItem jMenuItem18 = new JMenuItem("Release Notes");
        JMenuItem jMenuItem19 = new JMenuItem("Check for Updates");
        JMenuItem jMenuItem20 = new JMenuItem("About");
        jMenu4.add(jMenuItem15);
        jMenu4.add(jMenuItem16);
        jMenu4.add(jMenuItem17);
        jMenu4.addSeparator();
        jMenu4.add(jMenuItem18);
        jMenu4.add(jMenuItem19);
        jMenu4.addSeparator();
        jMenu4.add(jMenuItem20);
        this.jMenuBar.add(this.applicationMenu);
        this.jMenuBar.add(this.manageMenu);
        this.jMenuBar.add(this.runMenu);
        this.jMenuBar.add(this.toolsMenu);
        this.jMenuBar.add(jMenu4);
    }

    private void addStartOptionToMenu(String string, String string2) {
        this.startMenuItem = new JMenuItem(string);
        this.startMenuItem.setActionCommand(string2);
        this.startMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.onStart(actionEvent);
            }
        });
        this.applicationMenu.add(this.startMenuItem);
        this.applicationMenu.addSeparator();
    }

    private String getTFAOwner() {
        String string = "ps -ef | grep \"oracle.rat.tfa.view.TraceFileAnalyzer\"| grep -v grep | awk '{print $1}'";
        String string2 = null;
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string3;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String getCurrentUser() {
        String string = "whoami";
        String string2 = null;
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string3;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String getPid(String string) {
        String string2 = null;
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string3;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private boolean isProcessRunning(String string) {
        String string2 = this.getPid(string);
        return string2 != null;
    }

    private boolean isTFARunningAsInit() {
        String string = "ps -ef | grep \"init.tfa run\"| grep -v grep | awk '{print $2}'";
        return this.isProcessRunning(string);
    }

    private boolean isTFARunning() {
        File file = new File(this.tfa_home_dir.getAbsolutePath() + File.separator + "tfa.lock");
        System.out.println("File : " + file + file.exists());
        return file.exists();
    }

    private void createToolBar() {
        this.toolBar = new JToolBar();
    }

    private void createCenterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.logArea = LogArea.getInstance();
        JScrollPane jScrollPane = new JScrollPane(this.logArea);
        jPanel.add((Component)jScrollPane, "Center");
        this.splitPane.setOrientation(0);
        this.splitPane.setDividerLocation(300);
        this.splitPane.add((Component)jPanel, "bottom");
        this.splitPane.add((Component)new JPanel(), "top");
    }

    private void updateStatusFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.tfa_home_dir.getAbsolutePath() + File.separator + "internal" + File.separator + "runstatus.txt"));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setMenusEnabled(boolean bl) {
        this.manageMenu.setEnabled(bl);
        this.runMenu.setEnabled(bl);
        this.toolsMenu.setEnabled(bl);
    }

    private void startTFAAsRoot() {
        this.logArea.append("Attempting to start Trace File Analyzer using init.tfa ...");
        this.startMenuItem.setText("Stop");
        this.startMenuItem.setActionCommand("rootStop");
        this.setMenusEnabled(true);
    }

    private void startTFA() {
        this.logArea.append("Attempting to start Trace File Analyzer ...");
        this.startMenuItem.setText("Stop");
        this.startMenuItem.setActionCommand("normalStop");
        this.setMenusEnabled(true);
    }

    private int checkTFAMain() {
        this.logArea.append("Inside checkTFAMain");
        String string = "check TFAMain";
        try {
            String string2;
            String string3 = this.getHostName();
            Socket socket = this.getSocketConnection(string3);
            this.sendMessage(socket, string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contentEquals("CheckOK")) continue;
                this.logArea.append("CheckOk!");
                return 1;
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return 0;
    }

    private void sleepDots(int n) {
        for (int i = 0; i < n; ++i) {
            this.logArea.append(".");
        }
    }

    private void stopTFAAsRoot() {
        this.logArea.append("Attempting to stop Trace File Analyzer using init.tfa ...");
        this.resetSplitPane();
        this.startMenuItem.setText("Start");
        this.startMenuItem.setActionCommand("rootStart");
        this.setMenusEnabled(false);
    }

    private int stopTFA() {
        int n;
        this.logArea.append("Stopping Trace File Analyzer ...");
        this.resetSplitPane();
        this.startMenuItem.setText("Start");
        this.startMenuItem.setActionCommand("normalStart");
        this.setMenusEnabled(false);
        this.updateStatusFile("stop");
        this.sleepDots(5);
        for (n = 0; this.checkTFAMain() == 1 && n < 3; ++n) {
            this.logArea.append("Socket still alive, will wait for 5 seconds.");
            this.sleepDots(5);
        }
        if (n < 3) {
            this.logArea.append("Reading the status file to check for stopped.");
            this.sleepDots(10);
            String string = this.readStatusFile();
            if (!string.equals("stopped")) {
                this.logArea.append("TFAMain stopped successfully!!");
                return 1;
            }
        }
        return 0;
    }

    private String readStatusFile() {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.tfa_home_dir.getAbsolutePath() + File.separator + "internal" + File.separator + "runstatus.txt"));
            string = bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    private void onStart(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getActionCommand();
        System.out.println("ActionCommand issued :::::::::: " + string);
        if (string.equals("normalStart")) {
            this.startTFA();
        } else if (string.equals("normalStop")) {
            System.out.println("Inside normalStop...");
            this.stopTFA();
        } else if (string.equals("rootStart")) {
            this.startTFAAsRoot();
        } else if (string.equals("rootStop")) {
            this.stopTFAAsRoot();
        }
    }

    private void onExit(ActionEvent actionEvent) {
        System.exit(0);
    }

    private String getHostName() {
        return new Host().getHostname();
    }

    private Socket getSocketConnection(String string) {
        Properties.getInstance();
        String string2 = Properties.trustStore;
        Properties.getInstance();
        String string3 = Properties.trustStorePassword;
        return SocketManager.getSecureSocketConnection(string, 4444, string2, string3);
    }

    private String getInventoryLastRun() {
        String string = null;
        String string2 = this.getHostName();
        String string3 = string2 + ":printinvrunstat";
        try {
            String string4;
            Socket socket = this.getSocketConnection(string2);
            this.sendMessage(socket, string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null && !string4.contentEquals("DONE")) {
                if (!string4.contains("Last Run End")) continue;
                string = string4.split(":")[1].trim();
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    private void manageCollections() {
        this.resetSplitPane();
        final ArrayList arrayList = new ArrayList();
        ZipEntityDA zipEntityDA = new ZipEntityDA();
        for (ZipEntity zipEntity : zipEntityDA.pIdx.entities()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Name", zipEntity.getFileNameShort().trim());
            String string = zipEntity.getFileNameFull();
            String string2 = string.substring(0, string.lastIndexOf(File.separator));
            hashMap.put("Location", string2.trim());
            hashMap.put("Creation Date", zipEntity.getDateCreated().toString());
            String string3 = String.valueOf(new File(zipEntity.getFileNameFull()).length() / 1024L);
            hashMap.put("Size in kB", string3);
            hashMap.put("Delete", new Boolean("false"));
            arrayList.add(hashMap);
        }
        System.out.println("Collections : " + arrayList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollectionMonitor collectionMonitor = CollectionMonitor.getInstance(TFAFrame.this, "Manage Collections", arrayList);
                collectionMonitor.setVisible(true);
            }
        });
    }

    private void printActions(String string) {
        this.resetSplitPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(true);
        jTextArea.setDisabledTextColor(Color.black);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        this.addToSplitPane(jPanel);
        String string2 = string + ":printactions";
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            jTextArea.append("The following actions were found in the database : \n");
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contentEquals("DONE")) {
                    this.logArea.append("Print Actions request completed.");
                    break;
                }
                jTextArea.append(string3 + "\n");
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void showActionMonitor() {
        this.resetSplitPane();
        this.updateActionAttributes();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionMonitor actionMonitor = ActionMonitor.getInstance(TFAFrame.this, "Action Monitor", TFAFrame.this.actionAttributes);
                actionMonitor.setVisible(true);
            }
        });
    }

    private List<String> getAllHostNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.resetSplitPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(true);
        jTextArea.setDisabledTextColor(Color.black);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        this.addToSplitPane(jPanel);
        String string = this.getHostName();
        String string2 = string + ":printhosts";
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null && !string3.contentEquals("DONE")) {
                if (!string3.contains("Host Name")) continue;
                arrayList.add(string3.split(":")[1].trim());
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    private void updateActionAttributes() {
        List<String> list = this.getAllHostNames();
        this.actionAttributes = new ArrayList();
        for (String string : list) {
            System.out.println("Current hostName : " + string);
            String string2 = string + ":printactions";
            try {
                String string3;
                Socket socket = this.getSocketConnection(string);
                this.sendMessage(socket, string2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                HashMap<String, String> hashMap = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    System.out.println("Input : " + string3);
                    if (string3.contentEquals("DONE")) break;
                    if (string3.contains("Action Name")) {
                        hashMap = new HashMap<String, String>();
                        stringArray = string3.split(":");
                        hashMap.put("Name", stringArray[1].trim());
                        continue;
                    }
                    if (string3.contains("Request Host")) {
                        hashMap.put("Host", string);
                        continue;
                    }
                    if (string3.contains("Request Client")) {
                        stringArray = string3.split(":");
                        hashMap.put("Client", stringArray[1].trim());
                        continue;
                    }
                    if (string3.contains("Request Time")) {
                        stringArray = string3.split(":");
                        hashMap.put("Start Time", stringArray[1].trim());
                        continue;
                    }
                    if (string3.contains("Request Status")) {
                        stringArray = string3.split(":");
                        hashMap.put("Status", stringArray[1].trim());
                        continue;
                    }
                    if (!string3.contains("Request Args")) continue;
                    stringArray = string3.split(":");
                    hashMap.put("Arguments", stringArray[1].trim());
                    this.actionAttributes.add(hashMap);
                }
                bufferedReader.close();
                System.out.println("Closing socket connection to : " + string);
                socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public ArrayList<Map<String, String>> getActionAttributes() {
        this.updateActionAttributes();
        return this.actionAttributes;
    }

    private void sendMessage(Socket socket, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            printWriter.println(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printHosts(ActionEvent actionEvent) {
        this.resetSplitPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(true);
        jTextArea.setDisabledTextColor(Color.black);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        this.addToSplitPane(jPanel);
        String string = this.getHostName();
        String string2 = string + ":printhosts";
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            jTextArea.append("The following hosts were found in the database : \n");
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contentEquals("DONE")) {
                    this.logArea.append("Print Hosts request completed.");
                    break;
                }
                if (string3.contains("Host Name")) {
                    jTextArea.append("\n");
                }
                jTextArea.append(string3 + "\n");
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printDirectories(ActionEvent actionEvent) {
        this.resetSplitPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(true);
        jTextArea.setDisabledTextColor(Color.black);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        this.addToSplitPane(jPanel);
        String string = this.getHostName();
        String string2 = string + ":printdirectories";
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            jTextArea.append("The following directories were found in the database : \n");
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contentEquals("DONE")) {
                    this.logArea.append("Print Directories request completed.");
                    break;
                }
                if (string3.contains("Directory to Scan")) {
                    jTextArea.append("\n");
                }
                jTextArea.append(string3 + "\n");
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printRepository(ActionEvent actionEvent) {
        this.resetSplitPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(true);
        jTextArea.setDisabledTextColor(Color.black);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        this.addToSplitPane(jPanel);
        String string = this.getHostName();
        String string2 = string + ":printrepository";
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contentEquals("DONE")) {
                    this.logArea.append("Print Repository request completed.");
                    break;
                }
                jTextArea.append(string3 + "\n");
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void collectZipFiles(String string) {
        String string2 = this.getHostName();
        String string3 = string2 + ":" + "ziptracesfordates:" + string;
        String string4 = string2 + ":ActionDone";
        System.out.println(string3);
        try {
            String string5;
            Socket socket = this.getSocketConnection(string2);
            this.sendMessage(socket, string3);
            this.sendMessage(socket, string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.logArea.append("Action added to TFA server \n");
            while ((string5 = bufferedReader.readLine()) != null) {
                if (!string5.contentEquals("SUCCESS")) continue;
                this.logArea.append("Collect zip files request completed.");
                break;
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void collectZipFiles(ActionEvent actionEvent) {
        this.resetSplitPane();
        CollectZipsDialog collectZipsDialog = new CollectZipsDialog(){

            @Override
            protected void onOk() {
                super.onOk();
                String string = this.getActionArgs();
                if (string != null) {
                    TFAFrame.this.collectZipFiles(string);
                    TFAFrame.this.resetSplitPane();
                }
            }

            @Override
            protected void onCancel() {
                TFAFrame.this.resetSplitPane();
            }
        };
        this.addToSplitPane(collectZipsDialog);
        collectZipsDialog.setVisible(true);
    }

    private void addHost(String string) {
        String string2 = this.getHostName();
        String string3 = string2 + ":addhost:" + string;
        this.logArea.append("actionMessage in addHosts() : " + string3);
        try {
            String string4;
            Socket socket = this.getSocketConnection(string2);
            this.sendMessage(socket, string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.contentEquals("SUCCESS")) {
                    this.logArea.append("Add Host request completed.");
                    break;
                }
                this.logArea.append(string4);
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void addHosts() {
        this.resetSplitPane();
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(200, 21));
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel("Enter Host Name"), null);
        jPanel.add((Component)jTextField, null);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final String string = jTextField.getText();
                if (string == null || string.length() == 0) {
                    TFAFrame.this.logArea.append("No host added.");
                    return;
                }
                TFAFrame.this.resetSplitPane();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TFAFrame.this.addHost(string);
                    }
                });
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.resetSplitPane();
            }
        });
        jPanel2.add((Component)jButton, null);
        jPanel2.add((Component)jButton2, null);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.addToSplitPane(jPanel3);
    }

    private void showPreferences(ActionEvent actionEvent) {
        this.resetSplitPane();
        this.preferencesDlg = new PreferencesDialog(this, "Preferences"){

            @Override
            protected void onOk(ActionEvent actionEvent) {
                super.onOk(actionEvent);
                TFAFrame.this.resetSplitPane();
                TFAFrame.this.logArea.append("Preferences updated successfully.");
            }

            @Override
            protected void onCancel(ActionEvent actionEvent) {
                super.onCancel(actionEvent);
                TFAFrame.this.resetSplitPane();
            }
        };
        this.addToSplitPane(this.preferencesDlg);
        this.preferencesDlg.setVisible(true);
    }

    private void addToSplitPane(JPanel jPanel) {
        this.splitPane.setDividerLocation(300);
        this.splitPane.add((Component)jPanel, "top");
    }

    private void resetSplitPane() {
        this.addToSplitPane(new JPanel());
    }

    private void addDirectory(ActionEvent actionEvent) {
        TreeView treeView = new TreeView(this.rootDir, 4, "Add Directory"){

            @Override
            protected void onOk(ActionEvent actionEvent) {
                super.onOk(actionEvent);
                if (this.isVisible()) {
                    return;
                }
                TFAFrame.this.resetSplitPane();
                ArrayList<File> arrayList = this.getSelectedFiles();
                if (arrayList.size() == 0) {
                    return;
                }
                String string = TFAFrame.this.getHostName();
                try {
                    String string2;
                    Socket socket = TFAFrame.this.getSocketConnection(string);
                    for (File file : arrayList) {
                        String string3 = string + ":adddirectory:" + file.getPath();
                        TFAFrame.this.sendMessage(socket, string3);
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        TFAFrame.this.logArea.append(string2);
                        if (!string2.contentEquals("SUCCESS")) continue;
                        TFAFrame.this.logArea.append("Add directories request completed.");
                        break;
                    }
                    bufferedReader.close();
                    socket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            @Override
            protected void onCancel(ActionEvent actionEvent) {
                super.onCancel(actionEvent);
                TFAFrame.this.resetSplitPane();
            }
        };
        this.addToSplitPane(treeView);
        treeView.setVisible(true);
    }

    private void removeDirectory(ActionEvent actionEvent) {
        TreeView treeView = new TreeView(this.rootDir, 4, "Remove Directory"){

            @Override
            protected void onOk(ActionEvent actionEvent) {
                super.onOk(actionEvent);
                if (this.isVisible()) {
                    return;
                }
                TFAFrame.this.resetSplitPane();
                ArrayList<File> arrayList = this.getSelectedFiles();
                if (arrayList.size() == 0) {
                    return;
                }
                String string = TFAFrame.this.getHostName();
                try {
                    String string2;
                    Socket socket = TFAFrame.this.getSocketConnection(string);
                    for (File file : arrayList) {
                        String string3 = string + ":removedirectory:" + file.getPath();
                        TFAFrame.this.sendMessage(socket, string3);
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        TFAFrame.this.logArea.append(string2);
                        if (!string2.contentEquals("SUCCESS")) continue;
                        TFAFrame.this.logArea.append("Remove directories request completed.");
                        break;
                    }
                    bufferedReader.close();
                    socket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            @Override
            protected void onCancel(ActionEvent actionEvent) {
                super.onCancel(actionEvent);
                TFAFrame.this.resetSplitPane();
            }
        };
        this.addToSplitPane(treeView);
        treeView.setVisible(true);
    }

    private void addRepository(ActionEvent actionEvent) {
        TreeView treeView = new TreeView(this.rootDir, 1, "Change Repository"){

            @Override
            protected void onOk(ActionEvent actionEvent) {
                super.onOk(actionEvent);
                if (this.isVisible()) {
                    return;
                }
                TFAFrame.this.resetSplitPane();
                ArrayList<File> arrayList = this.getSelectedFiles();
                if (arrayList.size() == 0) {
                    return;
                }
                TFAFrame.this.repo = arrayList.get(0);
                TFAFrame.this.addRepository();
            }

            @Override
            protected void onCancel(ActionEvent actionEvent) {
                super.onCancel(actionEvent);
                TFAFrame.this.resetSplitPane();
            }
        };
        this.addToSplitPane(treeView);
        treeView.setVisible(true);
    }

    private void addRepository() {
        String string = this.getHostName();
        String string2 = string + ":changerepository:" + this.repo.getPath() + " " + this.repoSize;
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contentEquals("SUCCESS")) {
                    this.logArea.append("Change Repository request completed.");
                    break;
                }
                this.logArea.append(string3);
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setRepositorySize(ActionEvent actionEvent) {
        this.resetSplitPane();
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(100, 21));
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel("Set Maximum Repository Size (MB)"), null);
        jPanel.add((Component)jTextField, null);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                if (string == null || string.length() == 0) {
                    TFAFrame.this.logArea.append("Please enter a value.");
                    return;
                }
                TFAFrame.this.resetSplitPane();
                TFAFrame.this.repoSize = string;
                TFAFrame.this.addRepository();
                TFAFrame.this.logArea.append("Repository Maximum size updated successfully.");
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.resetSplitPane();
            }
        });
        jPanel2.add((Component)jButton, null);
        jPanel2.add((Component)jButton2, null);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.addToSplitPane(jPanel3);
    }

    private void runScan() {
        this.resetSplitPane();
        String string = this.getHostName();
        String string2 = string + ":runodscan:NONE";
        try {
            String string3;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.logArea.append(string3);
                if (!string3.contentEquals("SUCCESS")) continue;
                this.logArea.append("OD Scan Requested.");
                break;
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void showRunScanDialog() {
        this.resetSplitPane();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.runScan();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.resetSplitPane();
            }
        });
        jPanel.add((Component)jButton, null);
        jPanel.add((Component)jButton2, null);
        String string = "Run Scan will scan all the files present in all the directories added to the Trace File Analyzer and captures startup, shutdown, general errors and system parameters with non-default values.";
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "South");
        jPanel2.add((Component)jTextArea, "Center");
        this.addToSplitPane(jPanel2);
    }

    private void showRunInventoryDialog() {
        this.resetSplitPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Run Locally");
        buttonGroup.add(jRadioButton);
        final JRadioButton jRadioButton2 = new JRadioButton("Run Clusterwide");
        jRadioButton2.setSelected(this.clusterwide);
        buttonGroup.add(jRadioButton2);
        JPanel jPanel = new JPanel();
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.runInventory(jRadioButton2.isSelected());
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFAFrame.this.resetSplitPane();
            }
        });
        jPanel2.add((Component)jButton, null);
        jPanel2.add((Component)jButton2, null);
        String string = "Run Inventory scans all directories added to the Trace File Analyzer and creates an inventory for each file in the directory.";
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        jPanel3.add((Component)jTextArea, "North");
        this.addToSplitPane(jPanel3);
    }

    private void runInventory(boolean bl) {
        this.resetSplitPane();
        String string = this.getHostName();
        String string2 = "";
        if (bl) {
            string2 = "-c";
        }
        String string3 = string + ":runinventory:" + string2;
        String string4 = string + ":ActionDone";
        try {
            String string5;
            Socket socket = this.getSocketConnection(string);
            this.sendMessage(socket, string3);
            this.sendMessage(socket, string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string5 = bufferedReader.readLine()) != null) {
                this.logArea.append(string5);
                if (!string5.contentEquals("SUCCESS")) continue;
                this.logArea.append("Action added to Trace File Analyzer server.");
                break;
            }
            bufferedReader.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

