/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import oracle.rat.tfa.view.TreeView;

public class PreferencesDialog
extends JPanel {
    private JTextField textField;
    private Frame parent;
    private String title;
    private File rootDir;

    public PreferencesDialog(Frame frame, String string) {
        this.parent = frame;
        this.title = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        File[] fileArray = File.listRoots();
        if (fileArray != null && fileArray.length != 0) {
            this.rootDir = fileArray[0];
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setEnabled(false);
        this.textField.setDisabledTextColor(Color.black);
        JButton jButton = new JButton("Change");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.changeParameterFile(actionEvent);
            }
        });
        jPanel.add((Component)new JLabel("Parameter File"), "West");
        jPanel.add((Component)this.textField, "Center");
        jPanel.add((Component)jButton, "East");
        JCheckBox jCheckBox = new JCheckBox("Cluster Wide Operation");
        jCheckBox.setSelected(true);
        JCheckBox jCheckBox2 = new JCheckBox("Verbose");
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(154, 100));
        jPanel2.add((Component)jPanel, null);
        jPanel2.add((Component)jCheckBox2, null);
        jPanel2.add((Component)jCheckBox, null);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.onOk(actionEvent);
            }
        });
        JButton jButton3 = new JButton("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.onCancel(actionEvent);
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton3, null);
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        if (this.title != null && this.title.length() != 0) {
            Border border = BorderFactory.createEmptyBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.title);
            titledBorder.setTitleJustification(2);
            this.setBorder(titledBorder);
        }
    }

    private void changeParameterFile(ActionEvent actionEvent) {
        final JDialog jDialog = new JDialog(this.parent, "Select Parameter File");
        TreeView treeView = new TreeView(this.rootDir, 1, ""){

            @Override
            protected void onOk(ActionEvent actionEvent) {
                super.onOk(actionEvent);
                if (this.isVisible()) {
                    return;
                }
                jDialog.setVisible(false);
                ArrayList<File> arrayList = this.getSelectedFiles();
                StringBuffer stringBuffer = new StringBuffer();
                for (File file : arrayList) {
                    stringBuffer.append(file.getPath() + " ");
                }
                PreferencesDialog.this.setSelectedPath(stringBuffer.toString());
            }

            @Override
            protected void onCancel(ActionEvent actionEvent) {
                super.onCancel(actionEvent);
                jDialog.setVisible(false);
            }
        };
        jDialog.setLayout(new BorderLayout());
        jDialog.add((Component)treeView, "Center");
        jDialog.setSize(new Dimension(415, 300));
        jDialog.setLocationRelativeTo(this.parent);
        jDialog.setVisible(true);
    }

    protected void onOk(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    protected void onCancel(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void setSelectedPath(String string) {
        this.textField.setText(string);
    }
}

