/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JCalendar
extends JPanel {
    private Vector<Integer> day = new Vector();
    private Vector<String> month = new Vector();
    private Vector<Integer> year = new Vector();
    private Vector<Integer> hour = new Vector();
    private Vector<Integer> minute = new Vector();
    private Vector<Integer> second = new Vector();
    private JComboBox yearOptions;
    private JComboBox monthOptions;
    private JComboBox dayOptions;
    private JComboBox hourOptions;
    private JComboBox minuteOptions;
    private JComboBox secondOptions;
    private boolean leapYear = false;
    private int dayCount = 30;
    private int yearStart = 2000;
    private int yearEnd = 2012;
    private JButton okButton;
    private JButton cancelButton;
    private LinkedHashMap<String, Integer> monthMap;
    private LinkedHashMap<Integer, String> reverseMonthMap;

    public JCalendar() {
        this.jbInit();
    }

    protected void jbInit() {
        this.loadVectors();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel("Year :"));
        this.yearOptions = new JComboBox<Integer>(this.year);
        jPanel.add(this.yearOptions);
        this.yearOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)JCalendar.this.yearOptions.getSelectedItem();
                if (n % 4 == 0) {
                    JCalendar.this.leapYear = true;
                }
            }
        });
        jPanel.add(new JLabel("Month :"));
        this.monthOptions = new JComboBox<String>(this.month);
        this.monthOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)JCalendar.this.monthOptions.getSelectedItem();
                if (string.equals("January") || string.equals("March") || string.equals("May") || string.equals("July") || string.equals("August") || string.equals("October") || string.equals("December")) {
                    JCalendar.this.dayCount = 31;
                } else if (string.equals("February") && JCalendar.this.leapYear) {
                    JCalendar.this.dayCount = 29;
                } else if (string.equals("February") && !JCalendar.this.leapYear) {
                    JCalendar.this.dayCount = 28;
                } else {
                    JCalendar.this.dayCount = 30;
                }
                this.updateDays();
            }

            private void updateDays() {
                System.out.println("updating days to " + JCalendar.this.dayCount);
                JCalendar.this.day.clear();
                for (int i = 1; i <= JCalendar.this.dayCount; ++i) {
                    JCalendar.this.day.add(i);
                }
            }
        });
        jPanel.add(this.monthOptions);
        this.dayOptions = new JComboBox<Integer>(this.day);
        jPanel.add(new JLabel("Day :"));
        jPanel.add(this.dayOptions);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.hourOptions = new JComboBox<Integer>(this.hour);
        jPanel2.add(new JLabel("Hour :"));
        jPanel2.add(this.hourOptions);
        this.minuteOptions = new JComboBox<Integer>(this.minute);
        jPanel2.add(new JLabel("Minute :"));
        jPanel2.add(this.minuteOptions);
        this.secondOptions = new JComboBox<Integer>(this.second);
        this.add(jPanel);
        this.add(jPanel2);
    }

    public String getDateString() {
        int n = (Integer)this.yearOptions.getSelectedItem();
        String string = (String)this.monthOptions.getSelectedItem();
        int n2 = this.monthMap.get(string);
        int n3 = (Integer)this.dayOptions.getSelectedItem();
        int n4 = (Integer)this.hourOptions.getSelectedItem();
        int n5 = (Integer)this.minuteOptions.getSelectedItem();
        int n6 = (Integer)this.secondOptions.getSelectedItem();
        String string2 = n2 + "." + n3 + "." + n + "." + n4 + "." + n5;
        return string2;
    }

    public void setDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M.dd.yyyy.HH.mm");
        String string = simpleDateFormat.format(date);
        String[] stringArray = string.split("\\.");
        int n = Integer.parseInt(stringArray[0]);
        this.monthOptions.setSelectedItem(this.reverseMonthMap.get(n));
        this.yearOptions.setSelectedItem(Integer.parseInt(stringArray[2]));
        this.dayOptions.setSelectedItem(Integer.parseInt(stringArray[1]));
        this.hourOptions.setSelectedItem(Integer.parseInt(stringArray[3]));
        this.minuteOptions.setSelectedItem(Integer.parseInt(stringArray[4]));
    }

    public Date getDate() {
        int n = (Integer)this.yearOptions.getSelectedItem();
        String string = (String)this.monthOptions.getSelectedItem();
        int n2 = (Integer)this.dayOptions.getSelectedItem();
        int n3 = (Integer)this.hourOptions.getSelectedItem();
        int n4 = (Integer)this.minuteOptions.getSelectedItem();
        int n5 = (Integer)this.secondOptions.getSelectedItem();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, this.monthMap.get(string));
        calendar.set(5, n2);
        calendar.set(10, n3);
        calendar.set(12, n4);
        calendar.set(13, n5);
        calendar.set(9, 0);
        return calendar.getTime();
    }

    private void onCancel() {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        JCalendar jCalendar = new JCalendar();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(jCalendar);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private void loadVectors() {
        int n;
        this.monthMap = new LinkedHashMap();
        this.monthMap.put("January", 1);
        this.monthMap.put("February", 2);
        this.monthMap.put("March", 3);
        this.monthMap.put("April", 4);
        this.monthMap.put("May", 5);
        this.monthMap.put("June", 6);
        this.monthMap.put("July", 7);
        this.monthMap.put("August", 8);
        this.monthMap.put("September", 9);
        this.monthMap.put("October", 10);
        this.monthMap.put("November", 11);
        this.monthMap.put("December", 12);
        this.reverseMonthMap = new LinkedHashMap();
        this.reverseMonthMap.put(1, "January");
        this.reverseMonthMap.put(2, "February");
        this.reverseMonthMap.put(3, "March");
        this.reverseMonthMap.put(4, "April");
        this.reverseMonthMap.put(5, "May");
        this.reverseMonthMap.put(6, "June");
        this.reverseMonthMap.put(7, "July");
        this.reverseMonthMap.put(8, "August");
        this.reverseMonthMap.put(9, "September");
        this.reverseMonthMap.put(10, "October");
        this.reverseMonthMap.put(11, "November");
        this.reverseMonthMap.put(12, "December");
        for (int i = this.yearStart; i <= this.yearEnd; ++i) {
            this.year.add(i);
        }
        for (String string : this.monthMap.keySet()) {
            this.month.add(string);
        }
        for (n = 1; n <= 31; ++n) {
            this.day.add(n);
        }
        for (n = 0; n <= 23; ++n) {
            this.hour.add(n);
        }
        for (n = 0; n <= 59; ++n) {
            this.minute.add(n);
        }
        for (n = 0; n <= 59; ++n) {
            this.second.add(n);
        }
    }
}

