/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class CollectionMonitor
extends JDialog {
    private JFrame parent;
    private JTable table;
    private static CollectionMonitor collectionMonitor;
    private List<Map<String, Object>> collectionAttributes;
    private static final String[] columnNames;
    private boolean DEBUG = true;

    private CollectionMonitor(JFrame jFrame, String string, List<Map<String, Object>> list) {
        super((Frame)jFrame, string);
        this.parent = jFrame;
        this.collectionAttributes = list;
        this.jbInit();
    }

    public static CollectionMonitor getInstance(JFrame jFrame, String string, List<Map<String, Object>> list) {
        if (collectionMonitor == null) {
            collectionMonitor = new CollectionMonitor(jFrame, string, list);
        }
        return collectionMonitor;
    }

    private void jbInit() {
        CollectionTableModel collectionTableModel = new CollectionTableModel(this.collectionAttributes);
        this.table = new JTable(collectionTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(800, 500));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer());
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JButton jButton = new JButton("Delete Selected Collections");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Map map : CollectionMonitor.this.collectionAttributes) {
                    System.out.println("Collection : " + map.get("Name") + " TBD : " + map.get("Delete"));
                    collectionMonitor.dispose();
                }
            }
        });
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CollectionMonitor.this.onClose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add((Component)jButton, null);
        jPanel.add((Component)jButton2, null);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void onClose() {
        collectionMonitor.dispose();
    }

    static {
        columnNames = new String[]{"Name", "Location", "Creation Date", "Size in kB", "Delete"};
    }

    private class CollectionTableModel
    extends AbstractTableModel {
        private transient List<Map<String, Object>> collectionAttributes;

        public CollectionTableModel(List<Map<String, Object>> list) {
            this.collectionAttributes = list;
        }

        @Override
        public int getRowCount() {
            return this.collectionAttributes.size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 4;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (CollectionMonitor.this.DEBUG) {
                System.out.println("Setting value at " + n + "," + n2 + " to " + object + " (an instance of " + object.getClass() + ")");
            }
            String string = this.getColumnName(n2);
            Map<String, Object> map = this.collectionAttributes.get(n);
            map.put(string, object);
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Map<String, Object> map = this.collectionAttributes.get(n);
            if (n2 == 0) {
                return map.get("Name");
            }
            if (n2 == 1) {
                return map.get("Location");
            }
            if (n2 == 2) {
                return map.get("Creation Date");
            }
            if (n2 == 3) {
                return map.get("Size in kB");
            }
            if (n2 == 4) {
                return map.get("Delete");
            }
            return null;
        }

        public void setContent(List<Map<String, Object>> list) {
            this.collectionAttributes = list;
            this.fireTableRowsInserted(0, list.size() - 1);
        }
    }

    private class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            this.setToolTipText((String)object);
            return this;
        }
    }
}

