/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.rat.tfa.view.TFAFrame;

public class ActionMonitor
extends JDialog {
    private JTable table;
    private JFrame parent;
    private static ActionMonitor actionMonitor;
    private List<Map<String, String>> actionAttributes;
    private static final String[] columnNames;

    private ActionMonitor(JFrame jFrame, String string, List<Map<String, String>> list) {
        super((Frame)jFrame, string);
        this.parent = jFrame;
        this.actionAttributes = list;
        this.jbInit();
    }

    public static ActionMonitor getInstance(JFrame jFrame, String string, List<Map<String, String>> list) {
        if (actionMonitor == null) {
            actionMonitor = new ActionMonitor(jFrame, string, list);
        }
        return actionMonitor;
    }

    public static ActionMonitor getInstance() {
        return actionMonitor;
    }

    private void jbInit() {
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new Updater(), 5000L, 5000L);
        ActionTableModel actionTableModel = new ActionTableModel(this.actionAttributes);
        this.table = new JTable(actionTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(800, 500));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer());
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionMonitor.this.onClose(actionEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add((Component)jButton, null);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                timer.cancel();
            }
        });
    }

    private void onClose(ActionEvent actionEvent) {
        actionMonitor.dispose();
    }

    static {
        columnNames = new String[]{"Name", "Status", "Host", "Client", "Start Time", "Arguments"};
    }

    private class ActionTableModel
    extends AbstractTableModel {
        private transient List<Map<String, String>> actionAttributes;

        public ActionTableModel(List<Map<String, String>> list) {
            this.actionAttributes = list;
        }

        @Override
        public int getRowCount() {
            return this.actionAttributes.size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Map<String, String> map = this.actionAttributes.get(n);
            if (n2 == 0) {
                return map.get("Name");
            }
            if (n2 == 1) {
                return map.get("Status");
            }
            if (n2 == 2) {
                return map.get("Host");
            }
            if (n2 == 3) {
                return map.get("Client");
            }
            if (n2 == 4) {
                return map.get("Start Time");
            }
            if (n2 == 5) {
                return map.get("Arguments");
            }
            return null;
        }

        public void setContent(List<Map<String, String>> list) {
            this.actionAttributes = list;
            this.fireTableRowsInserted(0, list.size() - 1);
        }
    }

    private class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            this.setToolTipText((String)object);
            return this;
        }
    }

    private class Updater
    extends TimerTask {
        private Updater() {
        }

        @Override
        public void run() {
            if (ActionMonitor.this.isShowing()) {
                ArrayList<Map<String, String>> arrayList = ((TFAFrame)ActionMonitor.this.parent).getActionAttributes();
                System.out.println("Inside Updater !!! " + arrayList.size());
                ((ActionTableModel)ActionMonitor.this.table.getModel()).setContent(arrayList);
            }
        }
    }
}

