/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import oracle.rat.tfa.util.EncryptionUtil;
import oracle.rat.tfa.util.Output;

public class WriteSSLConfig {
    private String tfahome;
    private String sslProperties;
    private String nonrootsslProperties;

    public WriteSSLConfig(String string) {
        this.tfahome = string;
        this.sslProperties = string + File.separator + "internal" + File.separator + "ssl.properties";
        this.nonrootsslProperties = string + File.separator + "internal" + File.separator + "nonrootssl.properties";
    }

    private void writeSslConfig(String string, String string2) {
        String string3 = this.sslProperties;
        File file = new File(string3);
        String string4 = string;
        try {
            string4 = EncryptionUtil.encrypt(string4);
        }
        catch (Exception exception) {
            Output.print("Exceptionin  writeSslConfig : " + exception.getMessage());
        }
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string3);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                fileInputStream.close();
                properties.setProperty("serverKeyStorePass", string4);
                properties.setProperty("serverTrustStorePass", string4);
                properties.setProperty("clientKeyStorePass", string4);
                properties.setProperty("clientTrustStorePass", string4);
                properties.setProperty("sslKey", string2);
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                properties.store(fileOutputStream, null);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Output.print("MessageHandler : IOException while updating sslconfig file: " + iOException.getMessage());
            }
            catch (Exception exception) {
                Output.print("MessageHandler : Exception while updating sslconfig file " + exception.getMessage());
            }
        } else {
            try {
                file.createNewFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
                bufferedWriter.write("serverKeyStorePass=" + string4 + "\n");
                bufferedWriter.write("serverTrustStorePass=" + string4 + "\n");
                bufferedWriter.write("clientKeyStorePass=" + string4 + "\n");
                bufferedWriter.write("clientTrustStorePass=" + string4 + "\n");
                bufferedWriter.write("sslKey=" + string2);
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Output.print("Error in creating " + file);
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                Output.print("Error in creating " + file);
                exception.printStackTrace();
            }
        }
    }

    private void writeNonRootSslConfig(String string) {
        String string2 = this.nonrootsslProperties;
        File file = new File(string2);
        String string3 = string;
        try {
            string3 = EncryptionUtil.encrypt(string3);
        }
        catch (Exception exception) {
            Output.print("Exceptionin  writeSslConfig : " + exception.getMessage());
        }
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                fileInputStream.close();
                properties.setProperty("serverKeyStorePass", string3);
                properties.setProperty("serverTrustStorePass", string3);
                properties.setProperty("clientKeyStorePass", string3);
                properties.setProperty("clientTrustStorePass", string3);
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                properties.store(fileOutputStream, null);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Output.print("MessageHandler : IOException while updating sslconfig file: " + iOException.getMessage());
            }
            catch (Exception exception) {
                Output.print("MessageHandler : Exception while updating sslconfig file " + exception.getMessage());
            }
        } else {
            try {
                file.createNewFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
                bufferedWriter.write("serverKeyStorePass=" + string3 + "\n");
                bufferedWriter.write("serverTrustStorePass=" + string3 + "\n");
                bufferedWriter.write("clientKeyStorePass=" + string3 + "\n");
                bufferedWriter.write("clientTrustStorePass=" + string3);
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Output.printTrace("Error in creating " + file, 3);
            }
        }
    }

    public static void main(String[] stringArray) {
        WriteSSLConfig writeSSLConfig = new WriteSSLConfig(stringArray[0].trim());
        String string = stringArray[1].trim();
        String string2 = stringArray[2].trim();
        Output.printTrace("Writing/updating ssl.properties file", 1);
        if (string2.equals("nonroot")) {
            writeSSLConfig.writeNonRootSslConfig(string);
        } else {
            writeSSLConfig.writeSslConfig(string, string2);
        }
    }
}

