/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class Utilities {
    public static synchronized String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String string = Properties.timezone;
        if (string != null) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        }
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static List<String> getOracleInstanceList(boolean bl) {
        String string = "";
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        string = new File(Properties.perlexe).exists() ? Properties.perlexe : File.separator + "usr" + File.separator + "bin" + File.separator + "perl";
        try {
            String string3 = string + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl getOracleInstanceList ";
            Output.printTrace("Utilities : Command : " + string3, 3);
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string4;
                if (bl) {
                    if (string2.contains("OracleService")) {
                        string4 = string2.substring(string2.indexOf("OracleService") + "OracleService".length());
                        arrayList.add(string4);
                    }
                    if (!string2.contains("OracleASMService")) continue;
                    string4 = string2.substring(string2.indexOf("OracleASMService") + "OracleASMService".length());
                    arrayList.add(string4);
                    continue;
                }
                if (!string2.contains("_pmon_")) continue;
                string4 = string2.substring(string2.indexOf("_pmon_") + "_pmon_".length());
                arrayList.add(string4);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("Utilities : Exception in getOracleInstanceList " + exception.getMessage(), 1);
        }
        Output.printTrace("Utilities : LINE : " + string2, 3);
        return arrayList;
    }

    public static void updateConfigPropertiesFile(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(Properties.configPropertiesFile);
            java.util.Properties properties = new java.util.Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.setProperty(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(Properties.configPropertiesFile);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Output.print("Utilities : IOException while updating config file: " + iOException.getMessage());
        }
        catch (Exception exception) {
            Output.print("Utilities : Exception while updating config file " + exception.getMessage());
        }
    }

    public static String getpropertyValue(String string, String string2) {
        String string3 = null;
        try {
            java.util.Properties properties = new java.util.Properties();
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            string3 = properties.getProperty(string);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static void writeToConfigPropertiesFile(String string, String string2) {
        try {
            java.util.Properties properties = new java.util.Properties();
            properties.setProperty(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(Properties.configPropertiesFile, true);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Output.print("Utilities : IOException while updating config file: " + iOException.getMessage());
        }
        catch (Exception exception) {
            Output.print("Utilities : Exception while updating config file " + exception.getMessage());
        }
    }

    public static boolean isCRSRunning() {
        boolean bl = false;
        if (Properties.crsHome == null) {
            Output.printTrace("isCRSRunning CRS_HOME not found", 3);
            return bl;
        }
        Properties.getInstance();
        String string = Properties.isWindows() ? Properties.crsHome + File.separator + "bin" + File.separator + "crsctl.exe" : Properties.crsHome + File.separator + "bin" + File.separator + "crsctl";
        int n = 0;
        if (new File(string).exists()) {
            try {
                String string2 = string + " check crs";
                Output.printTrace("isCRSRunning Command : " + string2, 3);
                Properties.getInstance();
                Process process = Properties.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string2}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string2});
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    Output.printTrace("Output Line : " + string3, 3);
                    if (!string3.contains("online")) continue;
                    ++n;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Output.print("IOException in isCRSRunning");
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                Output.print("Exception in isCRSRunning");
                exception.printStackTrace();
            }
        } else {
            Output.printTrace("isCRSRunning " + string + " not found", 1);
            return bl;
        }
        if (n == 4) {
            bl = true;
        }
        Output.printTrace("isCRSRunning Count : " + n + ", Status : " + bl, 3);
        return bl;
    }

    public static void triggerDiskSnapshot() {
        String string = "";
        String string2 = new Host().getHostname().trim();
        String string3 = Properties.tfaBase;
        try {
            Properties.getInstance();
            String string4 = Properties.isWindows() ? Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl.bat" : Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl";
            string4 = string4 + " managelogs -show usage -saveusage -node local";
            Output.printTrace("Utilities : Command : " + string4, 3);
            Process process = Runtime.getRuntime().exec(string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = bufferedReader.readLine();
            if (string != null) {
                Output.printTrace("Utilities : LINE : " + string, 3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("Utilities : Exception in triggerDiskSnapshot " + exception.getMessage(), 1);
        }
    }

    public static boolean isUserExists(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        string2 = new File(Properties.perlexe).exists() ? Properties.perlexe : File.separator + "usr" + File.separator + "bin" + File.separator + "perl";
        try {
            BufferedReader bufferedReader;
            Properties.getInstance();
            if (Properties.isWindows()) {
                String string5 = string2 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl listusers " + Properties.tfaHome;
                Output.printTrace("Utilities : Command : " + string5, 3);
                Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string5});
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string3 = bufferedReader.readLine();
                if (string3 != null) {
                    Output.printTrace("Utilities : LINE : " + string3, 3);
                    string4 = string4 + ":" + string3;
                }
                String[] stringArray = string4.split(":");
                Output.printTrace("MESSAGE : LISTOFUSERS : " + stringArray[1], 3);
                String[] stringArray2 = stringArray[1].split("\\s");
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].compareToIgnoreCase(string) != 0) continue;
                    bl = true;
                }
            } else {
                String string6 = "id " + string + " > /dev/null 2>&1; echo $?";
                Output.printTrace("Utilities : Command : " + string6, 3);
                Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string6});
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string3 = bufferedReader.readLine();
                if (string3 != null) {
                    Output.printTrace("Utilities : LINE : " + string3, 3);
                }
                bl = string3.equals("0");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("Utilities : Exception in isUserExists " + exception.getMessage(), 1);
        }
        return bl;
    }

    public static void triggerAutoPurge(String string) {
        String string2 = "";
        String string3 = new Host().getHostname().trim();
        String string4 = Properties.tfaBase;
        try {
            Properties.getInstance();
            String string5 = Properties.isWindows() ? Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl.bat" : Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl";
            string5 = string5 + " managelogs -purge -older " + string + " -node local";
            Output.printTrace("Utilities : Command : " + string5, 3);
            Process process = Runtime.getRuntime().exec(string5);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                Output.printTrace("Utilities : LINE : " + string2, 3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("Utilities : Exception in triggerAutoPurge " + exception.getMessage(), 1);
        }
    }
}

