/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class TimeZoneUtil {
    public static String getCRSTimeZone() {
        File file;
        String string = null;
        if (Properties.crsHome != null && (file = new File(Properties.crsHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params")).exists()) {
            String string2 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.startsWith("TZ=")) continue;
                    string = string2.substring(3);
                    Output.printTrace("TZ in crsconfig_params file : " + string, 3);
                    break;
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string;
    }

    public static String getTZInEnvironment() {
        String string = System.getenv("TZ");
        if (string == null) {
            string = TimeZoneUtil.readTZFromTFASetup();
        }
        return string;
    }

    public static String getSessionTimeZone() {
        String string = null;
        if (Properties.crsHome != null) {
            File file = new File(Properties.crsHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params");
            if (file.exists()) {
                String string2 = null;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!string2.startsWith("TZ=")) continue;
                        string = string2.substring(3);
                        break;
                    }
                    bufferedReader.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                string = System.getenv("TZ");
                if (string == null) {
                    string = TimeZoneUtil.readTZFromTFASetup();
                }
                if (string == null) {
                    string = TimeZone.getDefault().getID();
                }
            }
        } else {
            string = System.getenv("TZ");
            if (string == null) {
                string = TimeZoneUtil.readTZFromTFASetup();
            }
            if (string == null) {
                string = TimeZone.getDefault().getID();
            }
        }
        if (string != null && string.equals("localtime")) {
            string = TimeZone.getDefault().getID();
        }
        return string;
    }

    public static int getDifferenceBetweenDefaultAndSessionTZ() {
        int n = 0;
        TimeZone timeZone = TimeZone.getDefault();
        if (Properties.timezone == null) {
            return n;
        }
        TimeZone timeZone2 = TimeZone.getTimeZone(Properties.timezone);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        int n2 = gregorianCalendar.get(11);
        ((Calendar)gregorianCalendar).setTimeZone(timeZone2);
        int n3 = gregorianCalendar.get(11);
        n = n2 - n3;
        return n;
    }

    private static String readTZFromTFASetup() {
        String string = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.tfaPropertiesFile));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contains("TZ=")) continue;
                string = string2.substring(3);
                break;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Output.print("TimeZoneUtil : FileNotFoundException for " + Properties.tfaPropertiesFile);
        }
        catch (IOException iOException) {
            Output.print("TimeZoneUtil : IOException while reading " + Properties.tfaPropertiesFile);
        }
        return string;
    }

    public static int getDifferenceBetweenLocalAndRemoteTZ(String string) {
        int n = 0;
        TimeZone timeZone = TimeZone.getTimeZone(Properties.timezone);
        if (Properties.timezone == null) {
            return n;
        }
        TimeZone timeZone2 = TimeZone.getTimeZone(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        int n2 = gregorianCalendar.get(11);
        ((Calendar)gregorianCalendar).setTimeZone(timeZone2);
        int n3 = gregorianCalendar.get(11);
        n = n2 - n3;
        return n;
    }
}

