/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;

public class ThreadUtilities {
    private static ThreadGroup rootThreadGroup = null;

    private ThreadUtilities() {
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        rootThreadGroup = threadGroup2;
        return threadGroup2;
    }

    public static ThreadGroup[] getAllThreadGroups() {
        ThreadGroup threadGroup = ThreadUtilities.getRootThreadGroup();
        int n = threadGroup.activeGroupCount();
        int n2 = 0;
        ThreadGroup[] threadGroupArray = null;
        while ((n2 = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n *= 2], true)) == n) {
        }
        ThreadGroup[] threadGroupArray2 = new ThreadGroup[n2 + 1];
        threadGroupArray2[0] = threadGroup;
        System.arraycopy(threadGroupArray, 0, threadGroupArray2, 1, n2);
        return threadGroupArray2;
    }

    public static ThreadGroup getThreadGroup(String string) {
        ThreadGroup[] threadGroupArray;
        if (string == null) {
            throw new NullPointerException("Null name");
        }
        for (ThreadGroup threadGroup : threadGroupArray = ThreadUtilities.getAllThreadGroups()) {
            if (!threadGroup.getName().equals(string)) continue;
            return threadGroup;
        }
        return null;
    }

    public static Thread[] getAllThreads() {
        ThreadGroup threadGroup = ThreadUtilities.getRootThreadGroup();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int n = threadMXBean.getThreadCount();
        int n2 = 0;
        Thread[] threadArray = null;
        while ((n2 = threadGroup.enumerate(threadArray = new Thread[n *= 2], true)) == n) {
        }
        return threadArray;
    }

    public static Thread[] getGroupThreads(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("Null group");
        }
        int n = threadGroup.activeCount();
        int n2 = 0;
        Thread[] threadArray = null;
        while ((n2 = threadGroup.enumerate(threadArray = new Thread[n *= 2], false)) == n) {
        }
        return threadArray;
    }

    public static Thread[] getGroupThreads(String string) {
        ThreadGroup threadGroup = ThreadUtilities.getThreadGroup(string);
        if (threadGroup == null) {
            return null;
        }
        return ThreadUtilities.getGroupThreads(threadGroup);
    }

    public static Thread[] getAllThreadsPrioritized() {
        Thread[] threadArray = ThreadUtilities.getAllThreads();
        Arrays.sort(threadArray, new Comparator<Thread>(){

            @Override
            public int compare(Thread thread, Thread thread2) {
                return thread2.getPriority() - thread.getPriority();
            }
        });
        return threadArray;
    }

    public static Thread[] getAllDaemonThreads() {
        Thread[] threadArray = ThreadUtilities.getAllThreads();
        Thread[] threadArray2 = new Thread[threadArray.length];
        int n = 0;
        for (Thread thread : threadArray) {
            if (!thread.isDaemon()) continue;
            threadArray2[n++] = thread;
        }
        return threadArray2;
    }

    public static Thread[] getAllThreads(Thread.State state) {
        Thread[] threadArray = ThreadUtilities.getAllThreads();
        Thread[] threadArray2 = new Thread[threadArray.length];
        int n = 0;
        for (Thread thread : threadArray) {
            if (thread.getState() != state) continue;
            threadArray2[n++] = thread;
        }
        return threadArray2;
    }

    public static Thread getThread(String string) {
        Thread[] threadArray;
        if (string == null) {
            throw new NullPointerException("Null name");
        }
        for (Thread thread : threadArray = ThreadUtilities.getAllThreads()) {
            if (!thread.getName().equals(string)) continue;
            return thread;
        }
        return null;
    }

    public static Thread getThread(long l) {
        Thread[] threadArray;
        for (Thread thread : threadArray = ThreadUtilities.getAllThreads()) {
            if (thread.getId() != l) continue;
            return thread;
        }
        return null;
    }

    public static Thread getThread(ThreadInfo threadInfo) {
        if (threadInfo == null) {
            throw new NullPointerException("Null info");
        }
        return ThreadUtilities.getThread(threadInfo.getThreadId());
    }
}

