/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class TFASignalHandler
implements SignalHandler {
    private SignalHandler oldHandler;

    public static SignalHandler install(String string) {
        try {
            Signal signal = new Signal(string);
            TFASignalHandler tFASignalHandler = new TFASignalHandler();
            tFASignalHandler.oldHandler = Signal.handle(signal, tFASignalHandler);
            return tFASignalHandler;
        }
        catch (Exception exception) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.out.println("Inside Add Shutdown Hook");
                    try {
                        BufferedWriter bufferedWriter = null;
                        bufferedWriter = new BufferedWriter(new FileWriter(Properties.statusFileName));
                        bufferedWriter.write("stop");
                        bufferedWriter.newLine();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            TFASignalHandler tFASignalHandler = new TFASignalHandler();
            return tFASignalHandler;
        }
    }

    @Override
    public void handle(Signal signal) {
        BufferedWriter bufferedWriter = null;
        Output.printTrace("Recieved Signal: " + signal.toString(), 1);
        if (!"TERM".equals(signal.getName())) {
            SignalHandler.SIG_DFL.handle(signal);
            return;
        }
        try {
            Output.printTrace("Handling Signal: " + signal.toString(), 1);
            bufferedWriter = new BufferedWriter(new FileWriter(Properties.statusFileName));
            bufferedWriter.write("stop");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

