/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.ComponentEntity;
import oracle.rat.tfa.singletons.MaskStrings;
import oracle.rat.tfa.type.MaskString;
import oracle.rat.tfa.util.Output;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StringUtil {
    private static StringUtil instance;

    private StringUtil() {
    }

    public StringUtil getInstance() {
        if (instance == null) {
            instance = new StringUtil();
        }
        return instance;
    }

    public static Date getDateFromString(String string) {
        int n;
        String[] stringArray = null;
        if (string.contains(".")) {
            stringArray = string.split("\\.");
        } else if (string.contains("/") && string.contains(":")) {
            String[] stringArray2 = string.split(" ");
            if (stringArray2.length > 1) {
                String[] stringArray3 = stringArray2[0].trim().split("/");
                String[] stringArray4 = stringArray2[1].trim().split(":");
                stringArray = new String[stringArray3.length + stringArray4.length];
                for (n = 0; n < stringArray3.length; ++n) {
                    stringArray[n] = stringArray3[n].trim();
                }
                for (n = 0; n < stringArray4.length; ++n) {
                    stringArray[stringArray3.length + n] = stringArray4[n].trim();
                }
            }
        } else if (string.contains("/")) {
            stringArray = string.split("/");
        } else {
            throw new EmptyStackException();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = 0;
        int n5 = 0;
        int n6 = 0;
        Calendar calendar = Calendar.getInstance();
        if (stringArray.length <= 0) {
            Output.print("NO MONTH FOUND***");
            throw new EmptyStackException();
        }
        String[] stringArray5 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        List<String> list = Arrays.asList(stringArray5);
        n2 = list.contains(stringArray[0]) ? list.indexOf(stringArray[0]) : new Integer(stringArray[0]).intValue();
        Output.print("Setting Month to " + n2);
        if (stringArray.length <= 1) {
            Output.print("NO DAY FOUND***");
            throw new EmptyStackException();
        }
        n3 = new Integer(stringArray[1]);
        Output.print("Setting Day to " + stringArray[1]);
        if (stringArray.length > 2) {
            n4 = new Integer(stringArray[2]);
            if (n4 < 30) {
                n4 = 2000 + n4;
            }
        } else {
            Output.print("NO YEAR FOUND***");
            throw new EmptyStackException();
        }
        if (stringArray.length > 3 && stringArray[3] != null) {
            Output.print("Setting Hour to " + stringArray[3]);
            n = new Integer(stringArray[3]);
        }
        if (stringArray.length > 4 && stringArray[4] != null) {
            Output.print("Setting Minute to " + stringArray[4]);
            n5 = new Integer(stringArray[4]);
        }
        if (stringArray.length > 5 && stringArray[5] != null) {
            Output.print("Setting Second to " + stringArray[5]);
            n6 = new Integer(stringArray[5]);
        }
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(1, n4);
        calendar.set(11, n);
        calendar.set(12, n5);
        calendar.set(13, n6);
        return calendar.getTime();
    }

    public static String getReplacementFor(String string) {
        Vector<MaskString> vector;
        String string2 = string;
        if (Global.maskingOn && (vector = MaskStrings.getInstance().getMaskStrings()) != null) {
            for (MaskString maskString : vector) {
                String string3 = maskString.getOriginal();
                String string4 = maskString.getReplacement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = string4;
                break;
            }
        }
        return string2;
    }

    public static List<ComponentEntity> parseXmlString(String string) {
        ArrayList<ComponentEntity> arrayList = new ArrayList<ComponentEntity>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("component");
            Output.print("Length: " + nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ComponentEntity componentEntity = new ComponentEntity();
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    NodeList nodeList2;
                    Element element;
                    Element element2 = (Element)node;
                    NodeList nodeList3 = element2.getElementsByTagName("name");
                    Element element3 = (Element)nodeList3.item(0);
                    NodeList nodeList4 = element3.getChildNodes();
                    String string2 = nodeList4.item(0).getNodeValue();
                    componentEntity.setComponent(string2);
                    NodeList nodeList5 = element2.getElementsByTagName("sub-components");
                    if (nodeList5 != null && (element = (Element)nodeList5.item(0)) != null && (nodeList2 = element.getElementsByTagName("subcomponent")) != null) {
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Element element4 = (Element)nodeList2.item(j);
                            String string3 = element4.getAttribute("name");
                            NodeList nodeList6 = element4.getChildNodes();
                            String string4 = nodeList6.item(0).getNodeValue();
                            componentEntity.addSubComponent(string3, string4);
                        }
                    }
                }
                arrayList.add(componentEntity);
            }
        }
        catch (Exception exception) {
            Output.print("Exception in parsing xmlsttring: " + exception.getMessage());
        }
        return arrayList;
    }
}

