/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.EncryptionUtil;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.RandomString;
import oracle.rat.tfa.util.Utilities;

public class SocketManager {
    private static SocketManager instance;
    private static SSLSocketFactory socketFactory;

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        if (instance == null) {
            instance = new SocketManager();
        }
        return instance;
    }

    public static void loadKeyStore(String string, String string2, String string3) throws Exception {
        SocketManager.loadKeyStore(string, string2, string3, null);
    }

    public static void loadKeyStore(String string, String string2, String string3, String string4) throws Exception {
        Object object;
        String string5 = string;
        char[] cArray = string3.toCharArray();
        char[] cArray2 = string2.toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(string5), cArray);
        KeyManagerFactory keyManagerFactory = SocketManager.getSystemSpecificKeyManager();
        keyManagerFactory.init(keyStore, cArray2);
        if (Global.protocol == null) {
            object = null;
            object = string4 == null ? Properties.configPropertiesFile : string4 + File.separator + "internal" + File.separator + "config.properties";
            if (object != null && new File((String)object).exists()) {
                Global.protocol = Utilities.getpropertyValue("protocol", (String)object);
            }
        }
        if (Global.protocol == null) {
            object = System.getProperty("java.version");
            double d = new Double((String)(object = ((String)object).substring(0, 3)));
            Global.protocol = d >= 1.7 ? "TLSv1.2" : "TLS";
        }
        object = SSLContext.getInstance(Global.protocol);
        ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), null, null);
        socketFactory = ((SSLContext)object).getSocketFactory();
    }

    public static SSLSocket getSecureSocketConnection(String string, int n, String string2, String string3) {
        Properties.getInstance();
        String string4 = Properties.clientKeyStorePassword;
        SSLSocket sSLSocket = null;
        sSLSocket = SocketManager.getSecureSocketConnection(string, n, string2, string4, string3);
        return sSLSocket;
    }

    public static SSLSocket getSecureSocketConnection(String string, int n, String string2, String string3, String string4) {
        SSLSocket sSLSocket = null;
        sSLSocket = SocketManager.getSecureSocketConnection(string, n, string2, string3, string4, null);
        return sSLSocket;
    }

    public static SSLSocket getSecureSocketConnection(String string, int n, String string2, String string3, String string4, String string5) {
        SSLSocket sSLSocket = null;
        try {
            if (socketFactory == null) {
                SocketManager.loadKeyStore(string2, string3, string4);
            }
            System.setProperty("javax.net.ssl.trustStore", string2);
            System.setProperty("javax.net.ssl.trustStorePassword", string4);
            int n2 = 30000;
            if (Global.getPortMapping() != null && Global.getPortMapping().containsKey(string)) {
                Output.printTrace("portMapping " + Global.getPortMapping(), 3);
                n = Global.getPortMapping().get(string);
                Output.printTrace("port in Global : " + n, 3);
            }
            sSLSocket = (SSLSocket)socketFactory.createSocket();
            SocketManager.disableRestrictedProtocols(sSLSocket, string5);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string.trim(), n);
            sSLSocket.connect(inetSocketAddress, n2);
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Unknown host : " + string + " " + unknownHostException.getMessage(), 3);
            sSLSocket = null;
        }
        catch (ConnectException connectException) {
            Output.printTrace("Unable to connect securely to socket in host : " + string + " on port : " + n + ". " + connectException.getMessage(), 3);
            sSLSocket = null;
        }
        catch (IOException iOException) {
            Output.printTrace("Unable to connect securely to socket in host : " + string + " on port : " + n + ". " + iOException.getMessage(), 3);
            sSLSocket = null;
        }
        catch (Exception exception) {
            Output.printTrace("Unable to connect securely to socket in host : " + string + " on port : " + n + ". " + exception.getMessage(), 3);
            sSLSocket = null;
        }
        return sSLSocket;
    }

    public static Socket getAuthenticatedSocketConnectionR(String string, String string2, int n, String string3) {
        Socket socket = null;
        try {
            socket = new Socket(string2, n);
            if (socket == null) {
                Output.printTrace("Failed to get secure socket connection to : " + string2, 1);
                return socket;
            }
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string4 = SocketManager.isAuthenticUser(string, printWriter, bufferedReader, EncryptionUtil.decrypt(string3));
            printWriter.flush();
            if (!string4.equals("SUCCESS")) {
                return null;
            }
            Output.printTrace("Authenticated receiever from client", 3);
        }
        catch (Exception exception) {
            Output.printTrace("Unable to connect securely to socket in host : " + string2 + " on port : " + n + ". " + exception.getMessage(), 1);
            socket = null;
        }
        return socket;
    }

    public static Socket getAuthenticatedSocketConnectionR(String string, int n, String string2) {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
            if (socket == null) {
                Output.printTrace("Failed to get secure socket connection to : " + string, 1);
                return socket;
            }
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string3 = SocketManager.isAuthenticUser(printWriter, bufferedReader, EncryptionUtil.decrypt(string2));
            printWriter.flush();
            if (!string3.equals("SUCCESS")) {
                return null;
            }
            Output.printTrace("Authenticated receiever from client", 3);
        }
        catch (Exception exception) {
            Output.printTrace("Unable to connect securely to socket in host : " + string + " on port : " + n + ". " + exception.getMessage(), 1);
            socket = null;
        }
        return socket;
    }

    public static Socket getSocketConnectionWithIP(String string, int n) {
        Socket socket = null;
        SocketFactory socketFactory = SocketFactory.getDefault();
        try {
            Output.printTrace("Connecting to host : " + string + " on port : " + n, 3);
            socket = socketFactory.createSocket(InetAddress.getByName(string), n);
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Unknown host : " + string, 3);
            socket = null;
        }
        catch (ConnectException connectException) {
            Output.printTrace("Unable to connect to private socket in host : " + string + " on port : " + n, 3);
            socket = null;
        }
        catch (IOException iOException) {
            socket = null;
        }
        catch (Exception exception) {
            socket = null;
        }
        return socket;
    }

    public static Socket getSocketConnection(String string, int n) {
        Socket socket = null;
        SocketFactory socketFactory = SocketFactory.getDefault();
        try {
            socket = socketFactory.createSocket(InetAddress.getByName(string), n);
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Unknown host : " + string, 3);
            socket = null;
            unknownHostException.printStackTrace();
        }
        catch (ConnectException connectException) {
            Output.print("Unable to connect to private socket in host : " + string + " on port : " + n);
            socket = null;
            connectException.printStackTrace();
        }
        catch (IOException iOException) {
            socket = null;
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            socket = null;
            exception.printStackTrace();
        }
        return socket;
    }

    public static String getTFAPort(String string) {
        String string2 = null;
        PrintWriter printWriter = null;
        String string3 = new Host().getHostname().trim();
        String string4 = string3 + ":checkTFAMain";
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        List<Integer> list = Properties.getInstance().getUsablePorts();
        SSLSocket sSLSocket = null;
        for (int n : Properties.getInstance().getUsablePorts()) {
            Output.printTrace("Trying to determine if TFA is listening on " + n + " in node " + string, 3);
            try {
                String string7;
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), n, string5, string6);
                if (sSLSocket == null) continue;
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string4);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string7 = bufferedReader.readLine()) != null) {
                    if (!string7.equals("CheckOK")) continue;
                    Output.printTrace("Received checkOK for port " + n, 3);
                    string2 = Integer.toString(n);
                    break;
                }
                bufferedReader.close();
                if (string2 != null) {
                    Output.printTrace("Port on which TFA is listening on node " + string + " is " + string2, 3);
                    break;
                }
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
            catch (Exception exception) {
                Output.printTrace("TFA is not listening on port " + n + " in node " + string, 3);
            }
        }
        return string2;
    }

    public static String getPrivatePort(String string) {
        String string2 = null;
        PrintWriter printWriter = null;
        String string3 = new Host().getHostname().trim();
        String string4 = string3 + ":checkPrivateConnAcceptor";
        List<Integer> list = Properties.getInstance().getUsablePorts();
        Socket socket = null;
        for (int n : list) {
            Properties.getInstance();
            if (n == new Integer(Properties.socketPort)) continue;
            try {
                String string5;
                socket = SocketManager.getSocketConnectionWithIP(string.trim(), n);
                if (socket == null) continue;
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                printWriter.println(string4);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while ((string5 = bufferedReader.readLine()) != null) {
                    if (!string5.equals("CheckOK")) continue;
                    Output.printTrace("Received checkOK for port " + n, 3);
                    string2 = Integer.toString(n);
                    break;
                }
                bufferedReader.close();
                if (string2 != null) break;
                if (socket.isClosed()) continue;
                socket.close();
            }
            catch (Exception exception) {
                Output.print("PrivateConnectionAcceptor is not listening on port " + n + " in node " + string);
            }
        }
        Output.printTrace("Port on which PrivateConnectionAcceptor is listening on node " + string + " is " + string2, 3);
        return string2;
    }

    public static void disableRestrictedProtocols(SSLSocket sSLSocket) {
        SocketManager.disableRestrictedProtocols(sSLSocket, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void disableRestrictedProtocols(SSLSocket sSLSocket, String string) {
        String[] stringArray = sSLSocket.getEnabledProtocols();
        HashSet<String> hashSet = new HashSet<String>();
        if (Global.restrictedProtocols.size() == 0) {
            String string2;
            void var4_7;
            Object object = null;
            if (string == null) {
                String string3 = Properties.configPropertiesFile;
            } else {
                String string4 = string + File.separator + "internal" + File.separator + "config.properties";
            }
            if (var4_7 != null && new File((String)var4_7).exists() && (string2 = Utilities.getpropertyValue("restrictedProtocols", (String)var4_7)) != null) {
                String[] stringArray2;
                string2 = string2.trim();
                for (String string5 : stringArray2 = string2.split(",")) {
                    Global.restrictedProtocols.add(string5);
                }
            }
        }
        for (String string6 : stringArray) {
            if (Global.restrictedProtocols.contains(string6)) continue;
            hashSet.add(string6);
        }
        sSLSocket.setEnabledProtocols(hashSet.toArray(new String[0]));
    }

    public static KeyManagerFactory getSystemSpecificKeyManager() throws Exception {
        KeyManagerFactory keyManagerFactory;
        if (Properties.isZlinux()) {
            Output.printTrace("Default KMF Algorithm: " + KeyManagerFactory.getDefaultAlgorithm(), 3);
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        } else {
            keyManagerFactory = Properties.isWindows() || Properties.isLinux() || Properties.isSolaris() ? KeyManagerFactory.getInstance("SunX509") : (Properties.isAIX() ? KeyManagerFactory.getInstance("IbmX509") : (Properties.isHPUX() ? KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()) : null));
        }
        return keyManagerFactory;
    }

    public static String isAuthenticUser(String string, PrintWriter printWriter, BufferedReader bufferedReader, String string2) {
        String string3 = "FAIL";
        try {
            Output.printTrace("isAuthenticUser: on [" + string + "] Start", 3);
            RandomString randomString = new RandomString(16);
            String string4 = randomString.nextString();
            String string5 = string + ":randomkey:" + string4;
            printWriter.println(string5);
            String string6 = bufferedReader.readLine();
            String string7 = EncryptionUtil.decryptStr(string6, string2);
            if (string7.equals(string4)) {
                string6 = bufferedReader.readLine();
                string7 = EncryptionUtil.decryptStr(string6, string2);
                string5 = EncryptionUtil.encryptStr(string7, string4);
                printWriter.println(string5);
                string5 = EncryptionUtil.encryptStr(string2, string4);
                Output.printTrace("Sending host key ", 3);
                printWriter.println(string5);
                String string8 = bufferedReader.readLine();
                string8 = string8.trim();
                if (string8.equals("OK")) {
                    string3 = "SUCCESS";
                }
            } else {
                Output.printTrace("isAuthenticUser: on [" + string + "] Wrong key", 1);
                string3 = string6;
            }
        }
        catch (Exception exception) {
            Output.printTrace("isAuthenticUser: on [" + string + "] Exception", 1);
            exception.printStackTrace();
        }
        Output.printTrace("isAuthenticUser: on [" + string + "] End", 3);
        return string3;
    }

    public static String isAuthenticUser(PrintWriter printWriter, BufferedReader bufferedReader, String string) {
        String string2 = "FAIL";
        String string3 = new Host().getHostname().trim();
        try {
            Output.printTrace("isAuthenticUser: on [" + string3 + "] Start", 3);
            RandomString randomString = new RandomString(16);
            String string4 = randomString.nextString();
            String string5 = string3 + ":randomkey:" + string4;
            printWriter.println(string5);
            String string6 = bufferedReader.readLine();
            String string7 = EncryptionUtil.decryptStr(string6, string);
            if (string7.equals(string4)) {
                string6 = bufferedReader.readLine();
                string7 = EncryptionUtil.decryptStr(string6, string);
                string5 = EncryptionUtil.encryptStr(string7, string4);
                printWriter.println(string5);
                string5 = EncryptionUtil.encryptStr(string, string4);
                Output.printTrace("Sending host key ", 3);
                printWriter.println(string5);
                String string8 = bufferedReader.readLine();
                string8 = string8.trim();
                if (string8.equals("OK")) {
                    string2 = "SUCCESS";
                }
            } else {
                Output.printTrace("isAuthenticUser: on [" + string3 + "] Wrong key", 1);
                string2 = string6;
            }
        }
        catch (Exception exception) {
            Output.printTrace("isAuthenticUser: on [" + string3 + "] Exception", 1);
            exception.printStackTrace();
        }
        Output.printTrace("isAuthenticUser: on [" + string3 + "] End", 3);
        return string2;
    }

    public static void main(String[] stringArray) {
    }
}

